<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebTaksitBanka StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebTaksitBanka
 * @subpackage Structs
 */
class WebTaksitBanka extends AbstractStructBase
{
    /**
     * The BankaAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankaAdi;
    /**
     * The BankaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BankaId;
    /**
     * The Taksitler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebTaksitSecenek
     */
    public $Taksitler;
    /**
     * Constructor method for WebTaksitBanka
     * @uses WebTaksitBanka::setBankaAdi()
     * @uses WebTaksitBanka::setBankaId()
     * @uses WebTaksitBanka::setTaksitler()
     * @param string $bankaAdi
     * @param int $bankaId
     * @param \ArrayType\ArrayOfWebTaksitSecenek $taksitler
     */
    public function __construct($bankaAdi = null, $bankaId = null, \ArrayType\ArrayOfWebTaksitSecenek $taksitler = null)
    {
        $this
            ->setBankaAdi($bankaAdi)
            ->setBankaId($bankaId)
            ->setTaksitler($taksitler);
    }
    /**
     * Get BankaAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankaAdi()
    {
        return isset($this->BankaAdi) ? $this->BankaAdi : null;
    }
    /**
     * Set BankaAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankaAdi
     * @return \StructType\WebTaksitBanka
     */
    public function setBankaAdi($bankaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($bankaAdi) && !is_string($bankaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankaAdi, true), gettype($bankaAdi)), __LINE__);
        }
        if (is_null($bankaAdi) || (is_array($bankaAdi) && empty($bankaAdi))) {
            unset($this->BankaAdi);
        } else {
            $this->BankaAdi = $bankaAdi;
        }
        return $this;
    }
    /**
     * Get BankaId value
     * @return int|null
     */
    public function getBankaId()
    {
        return $this->BankaId;
    }
    /**
     * Set BankaId value
     * @param int $bankaId
     * @return \StructType\WebTaksitBanka
     */
    public function setBankaId($bankaId = null)
    {
        // validation for constraint: int
        if (!is_null($bankaId) && !(is_int($bankaId) || ctype_digit($bankaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankaId, true), gettype($bankaId)), __LINE__);
        }
        $this->BankaId = $bankaId;
        return $this;
    }
    /**
     * Get Taksitler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebTaksitSecenek|null
     */
    public function getTaksitler()
    {
        return isset($this->Taksitler) ? $this->Taksitler : null;
    }
    /**
     * Set Taksitler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebTaksitSecenek $taksitler
     * @return \StructType\WebTaksitBanka
     */
    public function setTaksitler(\ArrayType\ArrayOfWebTaksitSecenek $taksitler = null)
    {
        if (is_null($taksitler) || (is_array($taksitler) && empty($taksitler))) {
            unset($this->Taksitler);
        } else {
            $this->Taksitler = $taksitler;
        }
        return $this;
    }
}
