<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getHesapDetaylari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetHesapDetaylari $parameters
     * @return GetHesapDetaylariResponse|bool
     */
    public function getHesapDetaylari(GetHesapDetaylari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHesapDetaylari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHesapHareketleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetHesapHareketleri $parameters
     * @return GetHesapHareketleriResponse|bool
     */
    public function getHesapHareketleri(GetHesapHareketleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHesapHareketleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetHesapDetaylariResponse|GetHesapHareketleriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
