<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHesap ArrayType
 * @subpackage Arrays
 */
class ArrayOfHesap extends AbstractStructArrayBase
{
    /**
     * The hesaplar
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Hesap[]
     */
    public $hesaplar;
    /**
     * Constructor method for ArrayOfHesap
     * @uses ArrayOfHesap::setHesaplar()
     * @param Hesap[] $hesaplar
     */
    public function __construct(array $hesaplar = array())
    {
        $this
            ->setHesaplar($hesaplar);
    }
    /**
     * Get hesaplar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Hesap[]|null
     */
    public function getHesaplar()
    {
        return isset($this->hesaplar) ? $this->hesaplar : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHesaplar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHesaplar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHesaplarForArrayConstraintsFromSetHesaplar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfHesapHesaplarItem) {
            // validation for constraint: itemType
            if (!$arrayOfHesapHesaplarItem instanceof Hesap) {
                $invalidValues[] = is_object($arrayOfHesapHesaplarItem) ? get_class($arrayOfHesapHesaplarItem) : sprintf('%s(%s)', gettype($arrayOfHesapHesaplarItem), var_export($arrayOfHesapHesaplarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hesaplar property can only contain items of type Hesap, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hesaplar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Hesap[] $hesaplar
     * @return ArrayOfHesap
     */
    public function setHesaplar(array $hesaplar = array())
    {
        // validation for constraint: array
        if ('' !== ($hesaplarArrayErrorMessage = self::validateHesaplarForArrayConstraintsFromSetHesaplar($hesaplar))) {
            throw new \InvalidArgumentException($hesaplarArrayErrorMessage, __LINE__);
        }
        if (is_null($hesaplar) || (is_array($hesaplar) && empty($hesaplar))) {
            unset($this->hesaplar);
        } else {
            $this->hesaplar = $hesaplar;
        }
        return $this;
    }
    /**
     * Add item to hesaplar value
     * @throws \InvalidArgumentException
     * @param Hesap $item
     * @return ArrayOfHesap
     */
    public function addToHesaplar(Hesap $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Hesap) {
            throw new \InvalidArgumentException(sprintf('The hesaplar property can only contain items of type Hesap, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hesaplar[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return Hesap|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return Hesap|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return Hesap|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return Hesap|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return Hesap|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string hesaplar
     */
    public function getAttributeName()
    {
        return 'hesaplar';
    }
}
