<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getHesapDetaylari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHesapDetaylari $parameters
     * @return \StructType\GetHesapDetaylariResponse|bool
     */
    public function getHesapDetaylari(\StructType\GetHesapDetaylari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHesapDetaylari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHesapHareketleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHesapHareketleri $parameters
     * @return \StructType\GetHesapHareketleriResponse|bool
     */
    public function getHesapHareketleri(\StructType\GetHesapHareketleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHesapHareketleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetHesapDetaylariResponse|\StructType\GetHesapHareketleriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
