<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVersions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetVersions $parameters
     * @return GetVersionsResponse|bool
     */
    public function GetVersions(GetVersions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVersions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiagnosisResult
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDiagnosisResult $parameters
     * @return GetDiagnosisResultResponse|bool
     */
    public function GetDiagnosisResult(GetDiagnosisResult $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDiagnosisResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Ping
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Ping $parameters
     * @return PingResponse|bool
     */
    public function Ping(Ping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Ping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ALive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ALive $parameters
     * @return ALiveResponse|bool
     */
    public function ALive(ALive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ALive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Login $parameters
     * @return LoginResponse|bool
     */
    public function Login(Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Logout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Logout $parameters
     * @return LogoutResponse|bool
     */
    public function Logout(Logout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Logout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendEnvelope $parameters
     * @return SendEnvelopeResponse|bool
     */
    public function sendEnvelope(SendEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendInvoice $parameters
     * @return SendInvoiceResponse|bool
     */
    public function sendInvoice(SendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendApplicationResponse $parameters
     * @return SendApplicationResponseResponse|bool
     */
    public function sendApplicationResponse(SendApplicationResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendApplicationResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendEnvelopeEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendEnvelopeEx $parameters
     * @return SendEnvelopeExResponse|bool
     */
    public function sendEnvelopeEx(SendEnvelopeEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendEnvelopeEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendInvoiceEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendInvoiceEx $parameters
     * @return SendInvoiceExResponse|bool
     */
    public function sendInvoiceEx(SendInvoiceEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendInvoiceEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSignedInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendSignedInvoice $parameters
     * @return SendSignedInvoiceResponse|bool
     */
    public function sendSignedInvoice(SendSignedInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSignedInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendApplicationResponseEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendApplicationResponseEx $parameters
     * @return SendApplicationResponseExResponse|bool
     */
    public function sendApplicationResponseEx(SendApplicationResponseEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendApplicationResponseEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendEArchiveDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendEArchiveDocument $parameters
     * @return SendEArchiveDocumentResponse|bool
     */
    public function sendEArchiveDocument(SendEArchiveDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendEArchiveDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveDocument $parameters
     * @return ReceiveDocumentResponse|bool
     */
    public function receiveDocument(ReceiveDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveDone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveDone $parameters
     * @return ReceiveDoneResponse|bool
     */
    public function receiveDone(ReceiveDone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveDone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveInvoice $parameters
     * @return ReceiveInvoiceResponse|bool
     */
    public function receiveInvoice(ReceiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveInvoiceDone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveInvoiceDone $parameters
     * @return ReceiveInvoiceDoneResponse|bool
     */
    public function receiveInvoiceDone(ReceiveInvoiceDone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveInvoiceDone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveApplicationResponse $parameters
     * @return ReceiveApplicationResponseResponse|bool
     */
    public function receiveApplicationResponse(ReceiveApplicationResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveApplicationResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named receiveApplicationResponseDone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ReceiveApplicationResponseDone $parameters
     * @return ReceiveApplicationResponseDoneResponse|bool
     */
    public function receiveApplicationResponseDone(ReceiveApplicationResponseDone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveApplicationResponseDone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetApplicationResponse $parameters
     * @return GetApplicationResponseResponse|bool
     */
    public function getApplicationResponse(GetApplicationResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInvoiceStatus $parameters
     * @return GetInvoiceStatusResponse|bool
     */
    public function getInvoiceStatus(GetInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppRespStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAppRespStatus $parameters
     * @return GetAppRespStatusResponse|bool
     */
    public function getAppRespStatus(GetAppRespStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppRespStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeList $parameters
     * @return GetEnvelopeListResponse|bool
     */
    public function getEnvelopeList(GetEnvelopeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelope $parameters
     * @return GetEnvelopeResponse|bool
     */
    public function getEnvelope(GetEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInvoiceList $parameters
     * @return GetInvoiceListResponse|bool
     */
    public function getInvoiceList(GetInvoiceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInvoice $parameters
     * @return GetInvoiceResponse|bool
     */
    public function getInvoice(GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetUserList $parameters
     * @return GetUserListResponse|bool
     */
    public function getUserList(GetUserList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserListNew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetUserListNew $parameters
     * @return GetUserListNewResponse|bool
     */
    public function getUserListNew(GetUserListNew $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserListNew($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApprovalFlowList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetApprovalFlowList $parameters
     * @return GetApprovalFlowListResponse|bool
     */
    public function getApprovalFlowList(GetApprovalFlowList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getApprovalFlowList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setApprovalFlowId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetApprovalFlowId $parameters
     * @return SetApprovalFlowIdResponse|bool
     */
    public function setApprovalFlowId(SetApprovalFlowId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setApprovalFlowId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApprovalFlowRes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetApprovalFlowRes $parameters
     * @return GetApprovalFlowResResponse|bool
     */
    public function getApprovalFlowRes(GetApprovalFlowRes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getApprovalFlowRes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentStatus $parameters
     * @return GetDocumentStatusResponse|bool
     */
    public function getDocumentStatus(GetDocumentStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDocumentStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentStatus_1 $parameters
     * @return GetDocumentStatusResponse_1|bool
     */
    public function GetDocumentStatus_1(GetDocumentStatus_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentStatusEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentStatusEx $parameters
     * @return GetDocumentStatusExResponse|bool
     */
    public function getDocumentStatusEx(GetDocumentStatusEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDocumentStatusEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEArchiveXslt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEArchiveXslt $parameters
     * @return GetEArchiveXsltResponse|bool
     */
    public function getEArchiveXslt(GetEArchiveXslt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEArchiveXslt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInvoiceApplicationResponse $parameters
     * @return GetInvoiceApplicationResponseResponse|bool
     */
    public function getInvoiceApplicationResponse(GetInvoiceApplicationResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceApplicationResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceResponseData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInvoiceResponseData $parameters
     * @return GetInvoiceResponseDataResponse|bool
     */
    public function getInvoiceResponseData(GetInvoiceResponseData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceResponseData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setApplicationResponseOption
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetApplicationResponseOption $parameters
     * @return SetApplicationResponseOptionResponse|bool
     */
    public function setApplicationResponseOption(SetApplicationResponseOption $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setApplicationResponseOption($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEArchiveInvoicePdfData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEArchiveInvoicePdfData $parameters
     * @return GetEArchiveInvoicePdfDataResponse|bool
     */
    public function getEArchiveInvoicePdfData(GetEArchiveInvoicePdfData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEArchiveInvoicePdfData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentData $parameters
     * @return GetDocumentDataResponse|bool
     */
    public function getDocumentData(GetDocumentData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDocumentData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentData_1 $parameters
     * @return GetDocumentDataResponse_1|bool
     */
    public function GetDocumentData_1(GetDocumentData_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReconciliationList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetReconciliationList $parameters
     * @return GetReconciliationListResponse|bool
     */
    public function getReconciliationList(GetReconciliationList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReconciliationList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendReconciliationReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendReconciliationReport $parameters
     * @return SendReconciliationReportResponse|bool
     */
    public function sendReconciliationReport(SendReconciliationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendReconciliationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createElementId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateElementId $parameters
     * @return CreateElementIdResponse|bool
     */
    public function createElementId(CreateElementId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createElementId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CancelEArchiveInvoice $parameters
     * @return CancelEArchiveInvoiceResponse|bool
     */
    public function cancelEArchiveInvoice(CancelEArchiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelEArchiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendEArchiveListForReconcilition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendEArchiveListForReconcilition $parameters
     * @return SendEArchiveListForReconcilitionResponse|bool
     */
    public function SendEArchiveListForReconcilition(SendEArchiveListForReconcilition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendEArchiveListForReconcilition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendDocument $parameters
     * @return SendDocumentResponse|bool
     */
    public function SendDocument(SendDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocument $parameters
     * @return GetDocumentResponse|bool
     */
    public function GetDocument(GetDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentDone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentDone $parameters
     * @return GetDocumentDoneResponse|bool
     */
    public function GetDocumentDone(GetDocumentDone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentDone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentStatusBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentStatusBatch $parameters
     * @return GetDocumentStatusBatchResponse|bool
     */
    public function GetDocumentStatusBatch(GetDocumentStatusBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentStatusBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDocumentList $parameters
     * @return GetDocumentListResponse|bool
     */
    public function GetDocumentList(GetDocumentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetValidateGIBUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetValidateGIBUser $parameters
     * @return GetValidateGIBUserResponse|bool
     */
    public function GetValidateGIBUser(GetValidateGIBUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetValidateGIBUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckGibUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CheckGibUser $parameters
     * @return CheckGibUserResponse|bool
     */
    public function CheckGibUser(CheckGibUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckGibUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetMailStatus $parameters
     * @return GetMailStatusResponse|bool
     */
    public function GetMailStatus(GetMailStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get2FACode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Get2FACode $parameters
     * @return Get2FACodeResponse|bool
     */
    public function Get2FACode(Get2FACode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get2FACode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get5K30KCancelObjectionStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Get5K30KCancelObjectionStatus $parameters
     * @return Get5K30KCancelObjectionStatusResponse|bool
     */
    public function Get5K30KCancelObjectionStatus(Get5K30KCancelObjectionStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get5K30KCancelObjectionStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ALiveResponse|CancelEArchiveInvoiceResponse|CheckGibUserResponse|CreateElementIdResponse|Get2FACodeResponse|Get5K30KCancelObjectionStatusResponse|GetApplicationResponseResponse|GetAppRespStatusResponse|GetApprovalFlowListResponse|GetApprovalFlowResResponse|GetDiagnosisResultResponse|GetDocumentDataResponse|GetDocumentDataResponse_1|GetDocumentDoneResponse|GetDocumentListResponse|GetDocumentResponse|GetDocumentStatusBatchResponse|GetDocumentStatusExResponse|GetDocumentStatusResponse|GetDocumentStatusResponse_1|GetEArchiveInvoicePdfDataResponse|GetEArchiveXsltResponse|GetEnvelopeListResponse|GetEnvelopeResponse|GetInvoiceApplicationResponseResponse|GetInvoiceListResponse|GetInvoiceResponse|GetInvoiceResponseDataResponse|GetInvoiceStatusResponse|GetMailStatusResponse|GetReconciliationListResponse|GetUserListNewResponse|GetUserListResponse|GetValidateGIBUserResponse|GetVersionsResponse|LoginResponse|LogoutResponse|PingResponse|ReceiveApplicationResponseDoneResponse|ReceiveApplicationResponseResponse|ReceiveDocumentResponse|ReceiveDoneResponse|ReceiveInvoiceDoneResponse|ReceiveInvoiceResponse|SendApplicationResponseExResponse|SendApplicationResponseResponse|SendDocumentResponse|SendEArchiveDocumentResponse|SendEArchiveListForReconcilitionResponse|SendEnvelopeExResponse|SendEnvelopeResponse|SendInvoiceExResponse|SendInvoiceResponse|SendReconciliationReportResponse|SendSignedInvoiceResponse|SetApplicationResponseOptionResponse|SetApprovalFlowIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
