<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDocumentResponse StructType
 * @subpackage Structs
 */
class SendDocumentResponse extends AbstractStructBase
{
    /**
     * The SendDocumentResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var EFaturaWebService_ResultType
     */
    public $SendDocumentResult;
    /**
     * The refId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $refId;
    /**
     * Constructor method for SendDocumentResponse
     * @uses SendDocumentResponse::setSendDocumentResult()
     * @uses SendDocumentResponse::setRefId()
     * @param EFaturaWebService_ResultType $sendDocumentResult
     * @param int $refId
     */
    public function __construct(EFaturaWebService_ResultType $sendDocumentResult = null, $refId = null)
    {
        $this
            ->setSendDocumentResult($sendDocumentResult)
            ->setRefId($refId);
    }
    /**
     * Get SendDocumentResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return EFaturaWebService_ResultType|null
     */
    public function getSendDocumentResult()
    {
        return isset($this->SendDocumentResult) ? $this->SendDocumentResult : null;
    }
    /**
     * Set SendDocumentResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param EFaturaWebService_ResultType $sendDocumentResult
     * @return SendDocumentResponse
     */
    public function setSendDocumentResult(EFaturaWebService_ResultType $sendDocumentResult = null)
    {
        if (is_null($sendDocumentResult) || (is_array($sendDocumentResult) && empty($sendDocumentResult))) {
            unset($this->SendDocumentResult);
        } else {
            $this->SendDocumentResult = $sendDocumentResult;
        }
        return $this;
    }
    /**
     * Get refId value
     * @return int|null
     */
    public function getRefId()
    {
        return $this->refId;
    }
    /**
     * Set refId value
     * @param int $refId
     * @return SendDocumentResponse
     */
    public function setRefId($refId = null)
    {
        $this->refId = $refId;
        return $this;
    }
}
