<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReconInvoiceType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReconInvoiceType
 * @subpackage Structs
 */
class ReconInvoiceType extends AbstractStructBase
{
    /**
     * The Cancel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Cancel;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceStatus;
    /**
     * The Uuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Uuid;
    /**
     * Constructor method for ReconInvoiceType
     * @uses ReconInvoiceType::setCancel()
     * @uses ReconInvoiceType::setInvoiceDate()
     * @uses ReconInvoiceType::setInvoiceNumber()
     * @uses ReconInvoiceType::setInvoiceStatus()
     * @uses ReconInvoiceType::setUuid()
     * @param bool $cancel
     * @param string $invoiceDate
     * @param string $invoiceNumber
     * @param string $invoiceStatus
     * @param string $uuid
     */
    public function __construct($cancel = null, $invoiceDate = null, $invoiceNumber = null, $invoiceStatus = null, $uuid = null)
    {
        $this
            ->setCancel($cancel)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceStatus($invoiceStatus)
            ->setUuid($uuid);
    }
    /**
     * Get Cancel value
     * @return bool|null
     */
    public function getCancel()
    {
        return $this->Cancel;
    }
    /**
     * Set Cancel value
     * @param bool $cancel
     * @return ReconInvoiceType
     */
    public function setCancel($cancel = null)
    {
        $this->Cancel = $cancel;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return ReconInvoiceType
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceNumber
     * @return ReconInvoiceType
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get InvoiceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceStatus()
    {
        return isset($this->InvoiceStatus) ? $this->InvoiceStatus : null;
    }
    /**
     * Set InvoiceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceStatus
     * @return ReconInvoiceType
     */
    public function setInvoiceStatus($invoiceStatus = null)
    {
        if (is_null($invoiceStatus) || (is_array($invoiceStatus) && empty($invoiceStatus))) {
            unset($this->InvoiceStatus);
        } else {
            $this->InvoiceStatus = $invoiceStatus;
        }
        return $this;
    }
    /**
     * Get Uuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->Uuid) ? $this->Uuid : null;
    }
    /**
     * Set Uuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uuid
     * @return ReconInvoiceType
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->Uuid);
        } else {
            $this->Uuid = $uuid;
        }
        return $this;
    }
}
