<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendEArchiveDocument StructType
 * @subpackage Structs
 */
class SendEArchiveDocument extends AbstractStructBase
{
    /**
     * The document
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var DocumentType
     */
    public $document;
    /**
     * The docType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docType;
    /**
     * The isSigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSigned;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * The xsltUuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xsltUuid;
    /**
     * Constructor method for sendEArchiveDocument
     * @uses SendEArchiveDocument::setDocument()
     * @uses SendEArchiveDocument::setDocType()
     * @uses SendEArchiveDocument::setIsSigned()
     * @uses SendEArchiveDocument::setSessionID()
     * @uses SendEArchiveDocument::setXsltUuid()
     * @param DocumentType $document
     * @param string $docType
     * @param bool $isSigned
     * @param string $sessionID
     * @param string $xsltUuid
     */
    public function __construct(DocumentType $document = null, $docType = null, $isSigned = null, $sessionID = null, $xsltUuid = null)
    {
        $this
            ->setDocument($document)
            ->setDocType($docType)
            ->setIsSigned($isSigned)
            ->setSessionID($sessionID)
            ->setXsltUuid($xsltUuid);
    }
    /**
     * Get document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DocumentType|null
     */
    public function getDocument()
    {
        return isset($this->document) ? $this->document : null;
    }
    /**
     * Set document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param DocumentType $document
     * @return SendEArchiveDocument
     */
    public function setDocument(DocumentType $document = null)
    {
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->document);
        } else {
            $this->document = $document;
        }
        return $this;
    }
    /**
     * Get docType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->docType;
    }
    /**
     * Set docType value
     * @param string $docType
     * @return SendEArchiveDocument
     */
    public function setDocType($docType = null)
    {
        $this->docType = $docType;
        return $this;
    }
    /**
     * Get isSigned value
     * @return bool|null
     */
    public function getIsSigned()
    {
        return $this->isSigned;
    }
    /**
     * Set isSigned value
     * @param bool $isSigned
     * @return SendEArchiveDocument
     */
    public function setIsSigned($isSigned = null)
    {
        $this->isSigned = $isSigned;
        return $this;
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return SendEArchiveDocument
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
    /**
     * Get xsltUuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXsltUuid()
    {
        return isset($this->xsltUuid) ? $this->xsltUuid : null;
    }
    /**
     * Set xsltUuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xsltUuid
     * @return SendEArchiveDocument
     */
    public function setXsltUuid($xsltUuid = null)
    {
        if (is_null($xsltUuid) || (is_array($xsltUuid) && empty($xsltUuid))) {
            unset($this->xsltUuid);
        } else {
            $this->xsltUuid = $xsltUuid;
        }
        return $this;
    }
}
