<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDocument StructType
 * @subpackage Structs
 */
class SendDocument extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * The paramList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfstring
     */
    public $paramList;
    /**
     * The document
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var DocumentType
     */
    public $document;
    /**
     * Constructor method for SendDocument
     * @uses SendDocument::setSessionID()
     * @uses SendDocument::setParamList()
     * @uses SendDocument::setDocument()
     * @param string $sessionID
     * @param ArrayOfstring $paramList
     * @param DocumentType $document
     */
    public function __construct($sessionID = null, ArrayOfstring $paramList = null, DocumentType $document = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setParamList($paramList)
            ->setDocument($document);
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return SendDocument
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
    /**
     * Get paramList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfstring|null
     */
    public function getParamList()
    {
        return isset($this->paramList) ? $this->paramList : null;
    }
    /**
     * Set paramList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfstring $paramList
     * @return SendDocument
     */
    public function setParamList(ArrayOfstring $paramList = null)
    {
        if (is_null($paramList) || (is_array($paramList) && empty($paramList))) {
            unset($this->paramList);
        } else {
            $this->paramList = $paramList;
        }
        return $this;
    }
    /**
     * Get document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DocumentType|null
     */
    public function getDocument()
    {
        return isset($this->document) ? $this->document : null;
    }
    /**
     * Set document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param DocumentType $document
     * @return SendDocument
     */
    public function setDocument(DocumentType $document = null)
    {
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->document);
        } else {
            $this->document = $document;
        }
        return $this;
    }
}
