<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResponse StructType
 * @subpackage Structs
 */
class LoginResponse extends AbstractStructBase
{
    /**
     * The LoginResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LoginResult;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * Constructor method for LoginResponse
     * @uses LoginResponse::setLoginResult()
     * @uses LoginResponse::setSessionID()
     * @param bool $loginResult
     * @param string $sessionID
     */
    public function __construct($loginResult = null, $sessionID = null)
    {
        $this
            ->setLoginResult($loginResult)
            ->setSessionID($sessionID);
    }
    /**
     * Get LoginResult value
     * @return bool|null
     */
    public function getLoginResult()
    {
        return $this->LoginResult;
    }
    /**
     * Set LoginResult value
     * @param bool $loginResult
     * @return LoginResponse
     */
    public function setLoginResult($loginResult = null)
    {
        $this->LoginResult = $loginResult;
        return $this;
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return LoginResponse
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
}
