<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDocumentStatusExResponse StructType
 * @subpackage Structs
 */
class GetDocumentStatusExResponse extends AbstractStructBase
{
    /**
     * The respStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $respStatus;
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $responseCode;
    /**
     * The responseDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $responseDesc;
    /**
     * The envelopeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $envelopeId;
    /**
     * The currentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentDate;
    /**
     * Constructor method for getDocumentStatusExResponse
     * @uses GetDocumentStatusExResponse::setRespStatus()
     * @uses GetDocumentStatusExResponse::setResponseCode()
     * @uses GetDocumentStatusExResponse::setResponseDesc()
     * @uses GetDocumentStatusExResponse::setEnvelopeId()
     * @uses GetDocumentStatusExResponse::setCurrentDate()
     * @param int $respStatus
     * @param int $responseCode
     * @param string $responseDesc
     * @param string $envelopeId
     * @param string $currentDate
     */
    public function __construct($respStatus = null, $responseCode = null, $responseDesc = null, $envelopeId = null, $currentDate = null)
    {
        $this
            ->setRespStatus($respStatus)
            ->setResponseCode($responseCode)
            ->setResponseDesc($responseDesc)
            ->setEnvelopeId($envelopeId)
            ->setCurrentDate($currentDate);
    }
    /**
     * Get respStatus value
     * @return int|null
     */
    public function getRespStatus()
    {
        return $this->respStatus;
    }
    /**
     * Set respStatus value
     * @param int $respStatus
     * @return GetDocumentStatusExResponse
     */
    public function setRespStatus($respStatus = null)
    {
        $this->respStatus = $respStatus;
        return $this;
    }
    /**
     * Get responseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param int $responseCode
     * @return GetDocumentStatusExResponse
     */
    public function setResponseCode($responseCode = null)
    {
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Get responseDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseDesc()
    {
        return isset($this->responseDesc) ? $this->responseDesc : null;
    }
    /**
     * Set responseDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseDesc
     * @return GetDocumentStatusExResponse
     */
    public function setResponseDesc($responseDesc = null)
    {
        if (is_null($responseDesc) || (is_array($responseDesc) && empty($responseDesc))) {
            unset($this->responseDesc);
        } else {
            $this->responseDesc = $responseDesc;
        }
        return $this;
    }
    /**
     * Get envelopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeId()
    {
        return isset($this->envelopeId) ? $this->envelopeId : null;
    }
    /**
     * Set envelopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeId
     * @return GetDocumentStatusExResponse
     */
    public function setEnvelopeId($envelopeId = null)
    {
        if (is_null($envelopeId) || (is_array($envelopeId) && empty($envelopeId))) {
            unset($this->envelopeId);
        } else {
            $this->envelopeId = $envelopeId;
        }
        return $this;
    }
    /**
     * Get currentDate value
     * @return string|null
     */
    public function getCurrentDate()
    {
        return $this->currentDate;
    }
    /**
     * Set currentDate value
     * @param string $currentDate
     * @return GetDocumentStatusExResponse
     */
    public function setCurrentDate($currentDate = null)
    {
        $this->currentDate = $currentDate;
        return $this;
    }
}
