<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDocumentStatus StructType
 * @subpackage Structs
 */
class GetDocumentStatus extends AbstractStructBase
{
    /**
     * The docType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $docType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uuid;
    /**
     * The relRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $relRef;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * Constructor method for getDocumentStatus
     * @uses GetDocumentStatus::setDocType()
     * @uses GetDocumentStatus::setUuid()
     * @uses GetDocumentStatus::setRelRef()
     * @uses GetDocumentStatus::setSessionID()
     * @param int $docType
     * @param string $uuid
     * @param int $relRef
     * @param string $sessionID
     */
    public function __construct($docType = null, $uuid = null, $relRef = null, $sessionID = null)
    {
        $this
            ->setDocType($docType)
            ->setUuid($uuid)
            ->setRelRef($relRef)
            ->setSessionID($sessionID);
    }
    /**
     * Get docType value
     * @return int|null
     */
    public function getDocType()
    {
        return $this->docType;
    }
    /**
     * Set docType value
     * @param int $docType
     * @return GetDocumentStatus
     */
    public function setDocType($docType = null)
    {
        $this->docType = $docType;
        return $this;
    }
    /**
     * Get uuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uuid
     * @return GetDocumentStatus
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get relRef value
     * @return int|null
     */
    public function getRelRef()
    {
        return $this->relRef;
    }
    /**
     * Set relRef value
     * @param int $relRef
     * @return GetDocumentStatus
     */
    public function setRelRef($relRef = null)
    {
        $this->relRef = $relRef;
        return $this;
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return GetDocumentStatus
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
}
