<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentStatusType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentStatusType
 * @subpackage Structs
 */
class DocumentStatusType extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $code;
    /**
     * The currentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentDate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The envelopeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $envelopeId;
    /**
     * The isCancel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isCancel;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The statusDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfstring
     */
    public $statusDetail;
    /**
     * Constructor method for DocumentStatusType
     * @uses DocumentStatusType::setCode()
     * @uses DocumentStatusType::setCurrentDate()
     * @uses DocumentStatusType::setDescription()
     * @uses DocumentStatusType::setEnvelopeId()
     * @uses DocumentStatusType::setIsCancel()
     * @uses DocumentStatusType::setStatus()
     * @uses DocumentStatusType::setStatusDetail()
     * @param int $code
     * @param string $currentDate
     * @param string $description
     * @param string $envelopeId
     * @param bool $isCancel
     * @param int $status
     * @param ArrayOfstring $statusDetail
     */
    public function __construct($code = null, $currentDate = null, $description = null, $envelopeId = null, $isCancel = null, $status = null, ArrayOfstring $statusDetail = null)
    {
        $this
            ->setCode($code)
            ->setCurrentDate($currentDate)
            ->setDescription($description)
            ->setEnvelopeId($envelopeId)
            ->setIsCancel($isCancel)
            ->setStatus($status)
            ->setStatusDetail($statusDetail);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return DocumentStatusType
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get currentDate value
     * @return string|null
     */
    public function getCurrentDate()
    {
        return $this->currentDate;
    }
    /**
     * Set currentDate value
     * @param string $currentDate
     * @return DocumentStatusType
     */
    public function setCurrentDate($currentDate = null)
    {
        $this->currentDate = $currentDate;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return DocumentStatusType
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get envelopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeId()
    {
        return isset($this->envelopeId) ? $this->envelopeId : null;
    }
    /**
     * Set envelopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeId
     * @return DocumentStatusType
     */
    public function setEnvelopeId($envelopeId = null)
    {
        if (is_null($envelopeId) || (is_array($envelopeId) && empty($envelopeId))) {
            unset($this->envelopeId);
        } else {
            $this->envelopeId = $envelopeId;
        }
        return $this;
    }
    /**
     * Get isCancel value
     * @return bool|null
     */
    public function getIsCancel()
    {
        return $this->isCancel;
    }
    /**
     * Set isCancel value
     * @param bool $isCancel
     * @return DocumentStatusType
     */
    public function setIsCancel($isCancel = null)
    {
        $this->isCancel = $isCancel;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return DocumentStatusType
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfstring|null
     */
    public function getStatusDetail()
    {
        return isset($this->statusDetail) ? $this->statusDetail : null;
    }
    /**
     * Set statusDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfstring $statusDetail
     * @return DocumentStatusType
     */
    public function setStatusDetail(ArrayOfstring $statusDetail = null)
    {
        if (is_null($statusDetail) || (is_array($statusDetail) && empty($statusDetail))) {
            unset($this->statusDetail);
        } else {
            $this->statusDetail = $statusDetail;
        }
        return $this;
    }
}
