<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentStatusBatchType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentStatusBatchType
 * @subpackage Structs
 */
class DocumentStatusBatchType extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $code;
    /**
     * The currentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currentDate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The envelopeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $envelopeId;
    /**
     * The isCancel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isCancel;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for DocumentStatusBatchType
     * @uses DocumentStatusBatchType::setCode()
     * @uses DocumentStatusBatchType::setCurrentDate()
     * @uses DocumentStatusBatchType::setDescription()
     * @uses DocumentStatusBatchType::setEnvelopeId()
     * @uses DocumentStatusBatchType::setIsCancel()
     * @uses DocumentStatusBatchType::setStatus()
     * @uses DocumentStatusBatchType::setUuid()
     * @param int $code
     * @param string $currentDate
     * @param string $description
     * @param string $envelopeId
     * @param bool $isCancel
     * @param int $status
     * @param string $uuid
     */
    public function __construct($code = null, $currentDate = null, $description = null, $envelopeId = null, $isCancel = null, $status = null, $uuid = null)
    {
        $this
            ->setCode($code)
            ->setCurrentDate($currentDate)
            ->setDescription($description)
            ->setEnvelopeId($envelopeId)
            ->setIsCancel($isCancel)
            ->setStatus($status)
            ->setUuid($uuid);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return DocumentStatusBatchType
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get currentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentDate()
    {
        return isset($this->currentDate) ? $this->currentDate : null;
    }
    /**
     * Set currentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentDate
     * @return DocumentStatusBatchType
     */
    public function setCurrentDate($currentDate = null)
    {
        if (is_null($currentDate) || (is_array($currentDate) && empty($currentDate))) {
            unset($this->currentDate);
        } else {
            $this->currentDate = $currentDate;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return DocumentStatusBatchType
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get envelopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeId()
    {
        return isset($this->envelopeId) ? $this->envelopeId : null;
    }
    /**
     * Set envelopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeId
     * @return DocumentStatusBatchType
     */
    public function setEnvelopeId($envelopeId = null)
    {
        if (is_null($envelopeId) || (is_array($envelopeId) && empty($envelopeId))) {
            unset($this->envelopeId);
        } else {
            $this->envelopeId = $envelopeId;
        }
        return $this;
    }
    /**
     * Get isCancel value
     * @return bool|null
     */
    public function getIsCancel()
    {
        return $this->isCancel;
    }
    /**
     * Set isCancel value
     * @param bool $isCancel
     * @return DocumentStatusBatchType
     */
    public function setIsCancel($isCancel = null)
    {
        $this->isCancel = $isCancel;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return DocumentStatusBatchType
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get uuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uuid
     * @return DocumentStatusBatchType
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
}
