<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setApplicationResponseOption StructType
 * @subpackage Structs
 */
class SetApplicationResponseOption extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * The option
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $option;
    /**
     * Constructor method for setApplicationResponseOption
     * @uses SetApplicationResponseOption::setSessionID()
     * @uses SetApplicationResponseOption::setOption()
     * @param string $sessionID
     * @param int $option
     */
    public function __construct($sessionID = null, $option = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setOption($option);
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return SetApplicationResponseOption
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
    /**
     * Get option value
     * @return int|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @param int $option
     * @return SetApplicationResponseOption
     */
    public function setOption($option = null)
    {
        $this->option = $option;
        return $this;
    }
}
