<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceVersionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceVersionResult
 * @subpackage Structs
 */
class ServiceVersionResult extends AbstractStructBase
{
    /**
     * The ApiVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiVersion;
    /**
     * The ReleaseVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReleaseVersion;
    /**
     * Constructor method for ServiceVersionResult
     * @uses ServiceVersionResult::setApiVersion()
     * @uses ServiceVersionResult::setReleaseVersion()
     * @param string $apiVersion
     * @param string $releaseVersion
     */
    public function __construct($apiVersion = null, $releaseVersion = null)
    {
        $this
            ->setApiVersion($apiVersion)
            ->setReleaseVersion($releaseVersion);
    }
    /**
     * Get ApiVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiVersion()
    {
        return isset($this->ApiVersion) ? $this->ApiVersion : null;
    }
    /**
     * Set ApiVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiVersion
     * @return ServiceVersionResult
     */
    public function setApiVersion($apiVersion = null)
    {
        if (is_null($apiVersion) || (is_array($apiVersion) && empty($apiVersion))) {
            unset($this->ApiVersion);
        } else {
            $this->ApiVersion = $apiVersion;
        }
        return $this;
    }
    /**
     * Get ReleaseVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReleaseVersion()
    {
        return isset($this->ReleaseVersion) ? $this->ReleaseVersion : null;
    }
    /**
     * Set ReleaseVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $releaseVersion
     * @return ServiceVersionResult
     */
    public function setReleaseVersion($releaseVersion = null)
    {
        if (is_null($releaseVersion) || (is_array($releaseVersion) && empty($releaseVersion))) {
            unset($this->ReleaseVersion);
        } else {
            $this->ReleaseVersion = $releaseVersion;
        }
        return $this;
    }
}
