<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendReconciliationReport StructType
 * @subpackage Structs
 */
class SendReconciliationReport extends AbstractStructBase
{
    /**
     * The report
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var DocumentType
     */
    public $report;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sessionID;
    /**
     * Constructor method for sendReconciliationReport
     * @uses SendReconciliationReport::setReport()
     * @uses SendReconciliationReport::setSessionID()
     * @param DocumentType $report
     * @param string $sessionID
     */
    public function __construct(DocumentType $report = null, $sessionID = null)
    {
        $this
            ->setReport($report)
            ->setSessionID($sessionID);
    }
    /**
     * Get report value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DocumentType|null
     */
    public function getReport()
    {
        return isset($this->report) ? $this->report : null;
    }
    /**
     * Set report value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param DocumentType $report
     * @return SendReconciliationReport
     */
    public function setReport(DocumentType $report = null)
    {
        if (is_null($report) || (is_array($report) && empty($report))) {
            unset($this->report);
        } else {
            $this->report = $report;
        }
        return $this;
    }
    /**
     * Get sessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->sessionID) ? $this->sessionID : null;
    }
    /**
     * Set sessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return SendReconciliationReport
     */
    public function setSessionID($sessionID = null)
    {
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->sessionID);
        } else {
            $this->sessionID = $sessionID;
        }
        return $this;
    }
}
