<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getUserList StructType
 * @subpackage Structs
 */
class GetUserList extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var LoginType
     */
    public $login;
    /**
     * The listType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $listType;
    /**
     * Constructor method for getUserList
     * @uses GetUserList::setLogin()
     * @uses GetUserList::setListType()
     * @param LoginType $login
     * @param string $listType
     */
    public function __construct(LoginType $login = null, $listType = null)
    {
        $this
            ->setLogin($login)
            ->setListType($listType);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return LoginType|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param LoginType $login
     * @return GetUserList
     */
    public function setLogin(LoginType $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get listType value
     * @return string|null
     */
    public function getListType()
    {
        return $this->listType;
    }
    /**
     * Set listType value
     * @param string $listType
     * @return GetUserList
     */
    public function setListType($listType = null)
    {
        $this->listType = $listType;
        return $this;
    }
}
