<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ccrCodCanton StructType
 * @subpackage Structs
 */
class CcrCodCanton extends AbstractStructBase
{
    /**
     * The Provincia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Provincia;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The Pass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pass;
    /**
     * Constructor method for ccrCodCanton
     * @uses CcrCodCanton::setProvincia()
     * @uses CcrCodCanton::setUser()
     * @uses CcrCodCanton::setPass()
     * @param int $provincia
     * @param string $user
     * @param string $pass
     */
    public function __construct($provincia = null, $user = null, $pass = null)
    {
        $this
            ->setProvincia($provincia)
            ->setUser($user)
            ->setPass($pass);
    }
    /**
     * Get Provincia value
     * @return int|null
     */
    public function getProvincia()
    {
        return $this->Provincia;
    }
    /**
     * Set Provincia value
     * @param int $provincia
     * @return \StructType\CcrCodCanton
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: int
        if (!is_null($provincia) && !is_numeric($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($provincia)), __LINE__);
        }
        $this->Provincia = $provincia;
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \StructType\CcrCodCanton
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get Pass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPass()
    {
        return isset($this->Pass) ? $this->Pass : null;
    }
    /**
     * Set Pass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pass
     * @return \StructType\CcrCodCanton
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pass)), __LINE__);
        }
        if (is_null($pass) || (is_array($pass) && empty($pass))) {
            unset($this->Pass);
        } else {
            $this->Pass = $pass;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CcrCodCanton
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
