<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ccr ServiceType
 * @subpackage Services
 */
class Ccr extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ccrGetTrackingInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrGetTrackingInfo $parameters
     * @return \StructType\CcrGetTrackingInfoResponse|bool
     */
    public function ccrGetTrackingInfo(\StructType\CcrGetTrackingInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrGetTrackingInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrMovilNotificaciones
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrMovilNotificaciones $parameters
     * @return \StructType\CcrMovilNotificacionesResponse|bool
     */
    public function ccrMovilNotificaciones(\StructType\CcrMovilNotificaciones $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrMovilNotificaciones($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrMovilTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrMovilTracking $parameters
     * @return \StructType\CcrMovilTrackingResponse|bool
     */
    public function ccrMovilTracking(\StructType\CcrMovilTracking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrMovilTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrMovilTarifaCCR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrMovilTarifaCCR $parameters
     * @return \StructType\CcrMovilTarifaCCRResponse|bool
     */
    public function ccrMovilTarifaCCR(\StructType\CcrMovilTarifaCCR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrMovilTarifaCCR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrMovilTarifaBOX
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrMovilTarifaBOX $parameters
     * @return \StructType\CcrMovilTarifaBOXResponse|bool
     */
    public function ccrMovilTarifaBOX(\StructType\CcrMovilTarifaBOX $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrMovilTarifaBOX($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrMovilTarifaBOX_2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrMovilTarifaBOX_2 $parameters
     * @return \StructType\CcrMovilTarifaBOX_2Response|bool
     */
    public function ccrMovilTarifaBOX_2(\StructType\CcrMovilTarifaBOX_2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrMovilTarifaBOX_2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrServiciosBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrServiciosBox $parameters
     * @return \StructType\CcrServiciosBoxResponse|bool
     */
    public function ccrServiciosBox(\StructType\CcrServiciosBox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrServiciosBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrServiciosCCR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrServiciosCCR $parameters
     * @return \StructType\CcrServiciosCCRResponse|bool
     */
    public function ccrServiciosCCR(\StructType\CcrServiciosCCR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrServiciosCCR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCodPostal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCodPostal $parameters
     * @return \StructType\CcrCodPostalResponse|bool
     */
    public function ccrCodPostal(\StructType\CcrCodPostal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCodPostal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrDistrito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrDistrito $parameters
     * @return \StructType\CcrDistritoResponse|bool
     */
    public function ccrDistrito(\StructType\CcrDistrito $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrDistrito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCodDistrito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCodDistrito $parameters
     * @return \StructType\CcrCodDistritoResponse|bool
     */
    public function ccrCodDistrito(\StructType\CcrCodDistrito $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCodDistrito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrProvincia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrProvincia $parameters
     * @return \StructType\CcrProvinciaResponse|bool
     */
    public function ccrProvincia(\StructType\CcrProvincia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrProvincia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCodProvincia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCodProvincia $parameters
     * @return \StructType\CcrCodProvinciaResponse|bool
     */
    public function ccrCodProvincia(\StructType\CcrCodProvincia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCodProvincia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrSucursalesCorreos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrSucursalesCorreos $parameters
     * @return \StructType\CcrSucursalesCorreosResponse|bool
     */
    public function ccrSucursalesCorreos(\StructType\CcrSucursalesCorreos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrSucursalesCorreos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrPaises
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrPaises $parameters
     * @return \StructType\CcrPaisesResponse|bool
     */
    public function ccrPaises(\StructType\CcrPaises $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrPaises($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCanton
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCanton $parameters
     * @return \StructType\CcrCantonResponse|bool
     */
    public function ccrCanton(\StructType\CcrCanton $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCanton($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCodCanton
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCodCanton $parameters
     * @return \StructType\CcrCodCantonResponse|bool
     */
    public function ccrCodCanton(\StructType\CcrCodCanton $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCodCanton($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrCanton2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrCanton2 $parameters
     * @return \StructType\CcrCanton2Response|bool
     */
    public function ccrCanton2(\StructType\CcrCanton2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrCanton2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrTracking $parameters
     * @return \StructType\CcrTrackingResponse|bool
     */
    public function ccrTracking(\StructType\CcrTracking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrRegistroEnvio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrRegistroEnvio $parameters
     * @return \StructType\CcrRegistroEnvioResponse|bool
     */
    public function ccrRegistroEnvio(\StructType\CcrRegistroEnvio $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrRegistroEnvio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrRegistroEnvioWeb
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrRegistroEnvioWeb $parameters
     * @return \StructType\CcrRegistroEnvioWebResponse|bool
     */
    public function ccrRegistroEnvioWeb(\StructType\CcrRegistroEnvioWeb $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrRegistroEnvioWeb($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrGenerarGuia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrGenerarGuia $parameters
     * @return \StructType\CcrGenerarGuiaResponse|bool
     */
    public function ccrGenerarGuia(\StructType\CcrGenerarGuia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrGenerarGuia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrGenerarGuiaWeb
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrGenerarGuiaWeb $parameters
     * @return \StructType\CcrGenerarGuiaWebResponse|bool
     */
    public function ccrGenerarGuiaWeb(\StructType\CcrGenerarGuiaWeb $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrGenerarGuiaWeb($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrListadoServiciosTienda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrListadoServiciosTienda $parameters
     * @return \StructType\CcrListadoServiciosTiendaResponse|bool
     */
    public function ccrListadoServiciosTienda(\StructType\CcrListadoServiciosTienda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrListadoServiciosTienda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ccrListadoServiciosTiendaDetallado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CcrListadoServiciosTiendaDetallado $parameters
     * @return \StructType\CcrListadoServiciosTiendaDetalladoResponse|bool
     */
    public function ccrListadoServiciosTiendaDetallado(\StructType\CcrListadoServiciosTiendaDetallado $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ccrListadoServiciosTiendaDetallado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CcrCanton2Response|\StructType\CcrCantonResponse|\StructType\CcrCodCantonResponse|\StructType\CcrCodDistritoResponse|\StructType\CcrCodPostalResponse|\StructType\CcrCodProvinciaResponse|\StructType\CcrDistritoResponse|\StructType\CcrGenerarGuiaResponse|\StructType\CcrGenerarGuiaWebResponse|\StructType\CcrGetTrackingInfoResponse|\StructType\CcrListadoServiciosTiendaDetalladoResponse|\StructType\CcrListadoServiciosTiendaResponse|\StructType\CcrMovilNotificacionesResponse|\StructType\CcrMovilTarifaBOXResponse|\StructType\CcrMovilTarifaBOX_2Response|\StructType\CcrMovilTarifaCCRResponse|\StructType\CcrMovilTrackingResponse|\StructType\CcrPaisesResponse|\StructType\CcrProvinciaResponse|\StructType\CcrRegistroEnvioResponse|\StructType\CcrRegistroEnvioWebResponse|\StructType\CcrServiciosBoxResponse|\StructType\CcrServiciosCCRResponse|\StructType\CcrSucursalesCorreosResponse|\StructType\CcrTrackingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
