<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bitrix ServiceType
 * @subpackage Services
 */
class Bitrix extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Bitrix24
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bitrix24 $parameters
     * @return \StructType\Bitrix24_Result|bool
     */
    public function Bitrix24(\StructType\Bitrix24 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Bitrix24($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Bitrix24_Result
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
