<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for root StructType
 * @subpackage Structs
 */
class Root extends AbstractStructBase
{
    /**
     * The Authentifizierung
     * @var \StructType\Authentifizierung
     */
    public $Authentifizierung;
    /**
     * The Nachweis_Daten
     * @var \StructType\Nachweis_Daten
     */
    public $Nachweis_Daten;
    /**
     * The Energieausweis_Daten
     * Meta information extracted from the WSDL
     * - choice: Energieausweis-Daten | EnergInspektions-Daten
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Energieausweis_Daten
     */
    public $Energieausweis_Daten;
    /**
     * The EnergInspektions_Daten
     * Meta information extracted from the WSDL
     * - choice: Energieausweis-Daten | EnergInspektions-Daten
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnergInspektions_Daten
     */
    public $EnergInspektions_Daten;
    /**
     * Constructor method for root
     * @uses Root::setAuthentifizierung()
     * @uses Root::setNachweis_Daten()
     * @uses Root::setEnergieausweis_Daten()
     * @uses Root::setEnergInspektions_Daten()
     * @param \StructType\Authentifizierung $authentifizierung
     * @param \StructType\Nachweis_Daten $nachweis_Daten
     * @param \StructType\Energieausweis_Daten $energieausweis_Daten
     * @param \StructType\EnergInspektions_Daten $energInspektions_Daten
     */
    public function __construct(\StructType\Authentifizierung $authentifizierung = null, \StructType\Nachweis_Daten $nachweis_Daten = null, \StructType\Energieausweis_Daten $energieausweis_Daten = null, \StructType\EnergInspektions_Daten $energInspektions_Daten = null)
    {
        $this
            ->setAuthentifizierung($authentifizierung)
            ->setNachweis_Daten($nachweis_Daten)
            ->setEnergieausweis_Daten($energieausweis_Daten)
            ->setEnergInspektions_Daten($energInspektions_Daten);
    }
    /**
     * Get Authentifizierung value
     * @return \StructType\Authentifizierung|null
     */
    public function getAuthentifizierung()
    {
        return $this->Authentifizierung;
    }
    /**
     * Set Authentifizierung value
     * @param \StructType\Authentifizierung $authentifizierung
     * @return \StructType\Root
     */
    public function setAuthentifizierung(\StructType\Authentifizierung $authentifizierung = null)
    {
        $this->Authentifizierung = $authentifizierung;
        return $this;
    }
    /**
     * Get Nachweis_Daten value
     * @return \StructType\Nachweis_Daten|null
     */
    public function getNachweis_Daten()
    {
        return $this->{'Nachweis-Daten'};
    }
    /**
     * Set Nachweis_Daten value
     * @param \StructType\Nachweis_Daten $nachweis_Daten
     * @return \StructType\Root
     */
    public function setNachweis_Daten(\StructType\Nachweis_Daten $nachweis_Daten = null)
    {
        $this->Nachweis_Daten = $this->{'Nachweis-Daten'} = $nachweis_Daten;
        return $this;
    }
    /**
     * Get Energieausweis_Daten value
     * @return \StructType\Energieausweis_Daten|null
     */
    public function getEnergieausweis_Daten()
    {
        return isset($this->{'Energieausweis-Daten'}) ? $this->{'Energieausweis-Daten'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEnergieausweis_Daten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnergieausweis_Daten method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEnergieausweis_DatenForChoiceConstraintsFromSetEnergieausweis_Daten($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'EnergInspektions_Daten',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Energieausweis-Daten can\'t be set as the property %s is already set. Only one property must be set among these properties: Energieausweis-Daten, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Energieausweis_Daten value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Energieausweis_Daten $energieausweis_Daten
     * @return \StructType\Root
     */
    public function setEnergieausweis_Daten(\StructType\Energieausweis_Daten $energieausweis_Daten = null)
    {
        // validation for constraint: choice(Energieausweis-Daten, EnergInspektions-Daten)
        if ('' !== ($energieausweis_DatenChoiceErrorMessage = self::validateEnergieausweis_DatenForChoiceConstraintsFromSetEnergieausweis_Daten($energieausweis_Daten))) {
            throw new \InvalidArgumentException($energieausweis_DatenChoiceErrorMessage, __LINE__);
        }
        if (is_null($energieausweis_Daten) || (is_array($energieausweis_Daten) && empty($energieausweis_Daten))) {
            unset($this->Energieausweis_Daten, $this->{'Energieausweis-Daten'});
        } else {
            $this->Energieausweis_Daten = $this->{'Energieausweis-Daten'} = $energieausweis_Daten;
        }
        return $this;
    }
    /**
     * Get EnergInspektions_Daten value
     * @return \StructType\EnergInspektions_Daten|null
     */
    public function getEnergInspektions_Daten()
    {
        return isset($this->{'EnergInspektions-Daten'}) ? $this->{'EnergInspektions-Daten'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEnergInspektions_Daten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnergInspektions_Daten method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEnergInspektions_DatenForChoiceConstraintsFromSetEnergInspektions_Daten($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Energieausweis_Daten',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EnergInspektions-Daten can\'t be set as the property %s is already set. Only one property must be set among these properties: EnergInspektions-Daten, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EnergInspektions_Daten value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EnergInspektions_Daten $energInspektions_Daten
     * @return \StructType\Root
     */
    public function setEnergInspektions_Daten(\StructType\EnergInspektions_Daten $energInspektions_Daten = null)
    {
        // validation for constraint: choice(Energieausweis-Daten, EnergInspektions-Daten)
        if ('' !== ($energInspektions_DatenChoiceErrorMessage = self::validateEnergInspektions_DatenForChoiceConstraintsFromSetEnergInspektions_Daten($energInspektions_Daten))) {
            throw new \InvalidArgumentException($energInspektions_DatenChoiceErrorMessage, __LINE__);
        }
        if (is_null($energInspektions_Daten) || (is_array($energInspektions_Daten) && empty($energInspektions_Daten))) {
            unset($this->EnergInspektions_Daten, $this->{'EnergInspektions-Daten'});
        } else {
            $this->EnergInspektions_Daten = $this->{'EnergInspektions-Daten'} = $energInspektions_Daten;
        }
        return $this;
    }
}
