<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rueckgabewert StructType
 * Meta information extracted from the WSDL
 * - documentation: Ist id gleich -1, dann ist ein allgemeines technisches Problem aufgetreten, Kontrolldatei wurde nicht gespeichert | Ist id größer 0, dann wurde bei der Prüfung der übergebenen Daten ein fachlicher Fehler festgestellt
 * (Beschreibung in value mit max. 200 Zeichen), Kontrolldatei wurde nicht gespeichert | Ist id gleich 0, dann war der Aufruf erfolgreich, Kontrolldatei wurde gespeichert | Ist id gleich -1, dann ist ein allgemeines technisches Problem aufgetreten,
 * Registriernummer wurde nicht erteilt | Ist id größer 0, dann wurde bei der Prüfung der übergebenen Daten ein fachlicher Fehler festgestellt (Beschreibung in value mit max. 200 Zeichen), Registriernummer wurde nicht erteilt | Ist id gleich 0, dann
 * war der Aufruf erfolgreich, Registriernummer wurde erteilt
 * @subpackage Structs
 */
class Rueckgabewert extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 200
     * - minOccurs: 1
     * @var string
     */
    public $value;
    /**
     * Constructor method for Rueckgabewert
     * @uses Rueckgabewert::setId()
     * @uses Rueckgabewert::setValue()
     * @param int $id
     * @param string $value
     */
    public function __construct($id = null, $value = null)
    {
        $this
            ->setId($id)
            ->setValue($value);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Rueckgabewert
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get value value
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Rueckgabewert
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($value) && mb_strlen($value) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
