<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Nachweis-Daten StructType
 * Meta information extracted from the WSDL
 * - documentation: Block, der die typunabhängigen Daten zur Beziehung einer Registriernummer vom DIBt enthält
 * @subpackage Structs
 */
class Nachweis_Daten extends AbstractStructBase
{
    /**
     * The Ausstellungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Ausstellungsdatum des Energieausweises
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ausstellungsdatum;
    /**
     * The Bundesland
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Bundesland;
    /**
     * The Postleitzahl
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl des Gebäudestandortes
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Postleitzahl;
    /**
     * The Gesetzesgrundlage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gesetzesgrundlage;
    /**
     * Constructor method for Nachweis-Daten
     * @uses Nachweis_Daten::setAusstellungsdatum()
     * @uses Nachweis_Daten::setBundesland()
     * @uses Nachweis_Daten::setPostleitzahl()
     * @uses Nachweis_Daten::setGesetzesgrundlage()
     * @param string $ausstellungsdatum
     * @param string $bundesland
     * @param string $postleitzahl
     * @param string $gesetzesgrundlage
     */
    public function __construct($ausstellungsdatum = null, $bundesland = null, $postleitzahl = null, $gesetzesgrundlage = null)
    {
        $this
            ->setAusstellungsdatum($ausstellungsdatum)
            ->setBundesland($bundesland)
            ->setPostleitzahl($postleitzahl)
            ->setGesetzesgrundlage($gesetzesgrundlage);
    }
    /**
     * Get Ausstellungsdatum value
     * @return string
     */
    public function getAusstellungsdatum()
    {
        return $this->Ausstellungsdatum;
    }
    /**
     * Set Ausstellungsdatum value
     * @param string $ausstellungsdatum
     * @return \StructType\Nachweis_Daten
     */
    public function setAusstellungsdatum($ausstellungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($ausstellungsdatum) && !is_string($ausstellungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausstellungsdatum, true), gettype($ausstellungsdatum)), __LINE__);
        }
        $this->Ausstellungsdatum = $ausstellungsdatum;
        return $this;
    }
    /**
     * Get Bundesland value
     * @return string
     */
    public function getBundesland()
    {
        return $this->Bundesland;
    }
    /**
     * Set Bundesland value
     * @uses \EnumType\Bundesland::valueIsValid()
     * @uses \EnumType\Bundesland::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bundesland
     * @return \StructType\Nachweis_Daten
     */
    public function setBundesland($bundesland = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Bundesland::valueIsValid($bundesland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Bundesland', is_array($bundesland) ? implode(', ', $bundesland) : var_export($bundesland, true), implode(', ', \EnumType\Bundesland::getValidValues())), __LINE__);
        }
        $this->Bundesland = $bundesland;
        return $this;
    }
    /**
     * Get Postleitzahl value
     * @return string
     */
    public function getPostleitzahl()
    {
        return $this->Postleitzahl;
    }
    /**
     * Set Postleitzahl value
     * @param string $postleitzahl
     * @return \StructType\Nachweis_Daten
     */
    public function setPostleitzahl($postleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($postleitzahl) && !is_string($postleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postleitzahl, true), gettype($postleitzahl)), __LINE__);
        }
        $this->Postleitzahl = $postleitzahl;
        return $this;
    }
    /**
     * Get Gesetzesgrundlage value
     * @return string
     */
    public function getGesetzesgrundlage()
    {
        return $this->Gesetzesgrundlage;
    }
    /**
     * Set Gesetzesgrundlage value
     * @uses \EnumType\Gesetzesgrundlage::valueIsValid()
     * @uses \EnumType\Gesetzesgrundlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gesetzesgrundlage
     * @return \StructType\Nachweis_Daten
     */
    public function setGesetzesgrundlage($gesetzesgrundlage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gesetzesgrundlage::valueIsValid($gesetzesgrundlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Gesetzesgrundlage', is_array($gesetzesgrundlage) ? implode(', ', $gesetzesgrundlage) : var_export($gesetzesgrundlage, true), implode(', ', \EnumType\Gesetzesgrundlage::getValidValues())), __LINE__);
        }
        $this->Gesetzesgrundlage = $gesetzesgrundlage;
        return $this;
    }
}
