<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnergInspektions-Daten StructType
 * Meta information extracted from the WSDL
 * - documentation: Weiterhin erforderliche Daten im Falle einer energetischen Inspektion
 * @subpackage Structs
 */
class EnergInspektions_Daten extends AbstractStructBase
{
    /**
     * The Nennleistung
     * Meta information extracted from the WSDL
     * - documentation: Nennleistung (Kälteerzeugung) der energetischen Anlage in kW
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minInclusive: 0.1
     * - minOccurs: 1
     * @var float
     */
    public $Nennleistung;
    /**
     * Constructor method for EnergInspektions-Daten
     * @uses EnergInspektions_Daten::setNennleistung()
     * @param float $nennleistung
     */
    public function __construct($nennleistung = null)
    {
        $this
            ->setNennleistung($nennleistung);
    }
    /**
     * Get Nennleistung value
     * @return float
     */
    public function getNennleistung()
    {
        return $this->Nennleistung;
    }
    /**
     * Set Nennleistung value
     * @param float $nennleistung
     * @return \StructType\EnergInspektions_Daten
     */
    public function setNennleistung($nennleistung = null)
    {
        // validation for constraint: float
        if (!is_null($nennleistung) && !(is_float($nennleistung) || is_numeric($nennleistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nennleistung, true), gettype($nennleistung)), __LINE__);
        }
        // validation for constraint: minInclusive(0.1)
        if (!is_null($nennleistung) && $nennleistung < 0.1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.1', var_export($nennleistung, true)), __LINE__);
        }
        $this->Nennleistung = $nennleistung;
        return $this;
    }
}
