<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for doc StructType
 * @subpackage Structs
 */
class Doc extends AbstractStructBase
{
    /**
     * The root
     * Meta information extracted from the WSDL
     * - ref: sde:root
     * @var \StructType\Root
     */
    public $root;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for doc
     * @uses Doc::setRoot()
     * @uses Doc::setAny()
     * @param \StructType\Root $root
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\Root $root = null, \DOMDocument $any = null)
    {
        $this
            ->setRoot($root)
            ->setAny($any);
    }
    /**
     * Get root value
     * @return \StructType\Root|null
     */
    public function getRoot()
    {
        return $this->root;
    }
    /**
     * Set root value
     * @param \StructType\Root $root
     * @return \StructType\Doc
     */
    public function setRoot(\StructType\Root $root = null)
    {
        $this->root = $root;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\Doc
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
