<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cons ServiceType
 * @subpackage Services
 */
class Cons extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsCertV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsCertV3Ent $consCertV3Ent
     * @return \StructType\ConsCertV3Sal|bool
     */
    public function ConsCertV3(\StructType\ConsCertV3Ent $consCertV3Ent)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsCertV3($consCertV3Ent));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsCertV3Sal
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
