<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RechazosTipo StructType
 * @subpackage Structs
 */
class RechazosTipo extends AbstractStructBase
{
    /**
     * The Certificado
     * Meta information extracted from the WSDL
     * - documentation: Número de certificado REA (usado en importación).
     * - base: xs:string
     * - length: 12
     * @var string
     */
    public $Certificado;
    /**
     * The CodErr
     * Meta information extracted from the WSDL
     * - documentation: Código de error. Pdte definir lista.
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $CodErr;
    /**
     * The DesErr
     * Meta information extracted from the WSDL
     * - documentation: Descripción del código de error. Pdte definir lista.
     * - base: xs:string
     * @var string
     */
    public $DesErr;
    /**
     * Constructor method for RechazosTipo
     * @uses RechazosTipo::setCertificado()
     * @uses RechazosTipo::setCodErr()
     * @uses RechazosTipo::setDesErr()
     * @param string $certificado
     * @param string $codErr
     * @param string $desErr
     */
    public function __construct($certificado = null, $codErr = null, $desErr = null)
    {
        $this
            ->setCertificado($certificado)
            ->setCodErr($codErr)
            ->setDesErr($desErr);
    }
    /**
     * Get Certificado value
     * @return string|null
     */
    public function getCertificado()
    {
        return $this->Certificado;
    }
    /**
     * Set Certificado value
     * @param string $certificado
     * @return \StructType\RechazosTipo
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        // validation for constraint: length(12)
        if (!is_null($certificado) && mb_strlen($certificado) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 12', mb_strlen($certificado)), __LINE__);
        }
        $this->Certificado = $certificado;
        return $this;
    }
    /**
     * Get CodErr value
     * @return string|null
     */
    public function getCodErr()
    {
        return $this->CodErr;
    }
    /**
     * Set CodErr value
     * @param string $codErr
     * @return \StructType\RechazosTipo
     */
    public function setCodErr($codErr = null)
    {
        // validation for constraint: string
        if (!is_null($codErr) && !is_string($codErr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codErr, true), gettype($codErr)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($codErr) && mb_strlen($codErr) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($codErr)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($codErr) && mb_strlen($codErr) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($codErr)), __LINE__);
        }
        $this->CodErr = $codErr;
        return $this;
    }
    /**
     * Get DesErr value
     * @return string|null
     */
    public function getDesErr()
    {
        return $this->DesErr;
    }
    /**
     * Set DesErr value
     * @param string $desErr
     * @return \StructType\RechazosTipo
     */
    public function setDesErr($desErr = null)
    {
        // validation for constraint: string
        if (!is_null($desErr) && !is_string($desErr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desErr, true), gettype($desErr)), __LINE__);
        }
        $this->DesErr = $desErr;
        return $this;
    }
}
