<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsCertifReaTipo StructType
 * @subpackage Structs
 */
class ConsCertifReaTipo extends AbstractStructBase
{
    /**
     * The Certificado
     * Meta information extracted from the WSDL
     * - documentation: Código del certificado REA. | Número de certificado REA (usado en importación).
     * - base: xs:string
     * - length: 12
     * @var string
     */
    public $Certificado;
    /**
     * The Estado
     * Meta information extracted from the WSDL
     * - documentation: Estado del Certificado | Código de estado del certificado, CP:Pendiente, CA:Asociado, CD:Despachado
     * - base: xs:string
     * - length: 2
     * @var string
     */
    public $Estado;
    /**
     * The Fecha
     * Meta information extracted from the WSDL
     * - documentation: Si el estado es CP, fecha de despacho del DUA, en el resto de casos, fecha de admisión o modificación del DUA. | Fecha en formato AAAAMMDD
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 8
     * @var string
     */
    public $Fecha;
    /**
     * The NumDUA
     * Meta information extracted from the WSDL
     * - documentation: Número de DUA de importación.
     * - base: xs:string
     * - maxLength: 21
     * - minLength: 11
     * @var string
     */
    public $NumDUA;
    /**
     * The PartidaDUA
     * Meta information extracted from the WSDL
     * - documentation: Partida del DUA.
     * - base: xs:string
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $PartidaDUA;
    /**
     * Constructor method for ConsCertifReaTipo
     * @uses ConsCertifReaTipo::setCertificado()
     * @uses ConsCertifReaTipo::setEstado()
     * @uses ConsCertifReaTipo::setFecha()
     * @uses ConsCertifReaTipo::setNumDUA()
     * @uses ConsCertifReaTipo::setPartidaDUA()
     * @param string $certificado
     * @param string $estado
     * @param string $fecha
     * @param string $numDUA
     * @param string $partidaDUA
     */
    public function __construct($certificado = null, $estado = null, $fecha = null, $numDUA = null, $partidaDUA = null)
    {
        $this
            ->setCertificado($certificado)
            ->setEstado($estado)
            ->setFecha($fecha)
            ->setNumDUA($numDUA)
            ->setPartidaDUA($partidaDUA);
    }
    /**
     * Get Certificado value
     * @return string|null
     */
    public function getCertificado()
    {
        return $this->Certificado;
    }
    /**
     * Set Certificado value
     * @param string $certificado
     * @return \StructType\ConsCertifReaTipo
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        // validation for constraint: length(12)
        if (!is_null($certificado) && mb_strlen($certificado) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 12', mb_strlen($certificado)), __LINE__);
        }
        $this->Certificado = $certificado;
        return $this;
    }
    /**
     * Get Estado value
     * @return string|null
     */
    public function getEstado()
    {
        return $this->Estado;
    }
    /**
     * Set Estado value
     * @param string $estado
     * @return \StructType\ConsCertifReaTipo
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($estado) && mb_strlen($estado) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($estado)), __LINE__);
        }
        $this->Estado = $estado;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string|null
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \StructType\ConsCertifReaTipo
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($fecha) && mb_strlen($fecha) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($fecha)), __LINE__);
        }
        // validation for constraint: minLength(8)
        if (!is_null($fecha) && mb_strlen($fecha) < 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 8', mb_strlen($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get NumDUA value
     * @return string|null
     */
    public function getNumDUA()
    {
        return $this->NumDUA;
    }
    /**
     * Set NumDUA value
     * @param string $numDUA
     * @return \StructType\ConsCertifReaTipo
     */
    public function setNumDUA($numDUA = null)
    {
        // validation for constraint: string
        if (!is_null($numDUA) && !is_string($numDUA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numDUA, true), gettype($numDUA)), __LINE__);
        }
        // validation for constraint: maxLength(21)
        if (!is_null($numDUA) && mb_strlen($numDUA) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 21', mb_strlen($numDUA)), __LINE__);
        }
        // validation for constraint: minLength(11)
        if (!is_null($numDUA) && mb_strlen($numDUA) < 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 11', mb_strlen($numDUA)), __LINE__);
        }
        $this->NumDUA = $numDUA;
        return $this;
    }
    /**
     * Get PartidaDUA value
     * @return string|null
     */
    public function getPartidaDUA()
    {
        return $this->PartidaDUA;
    }
    /**
     * Set PartidaDUA value
     * @param string $partidaDUA
     * @return \StructType\ConsCertifReaTipo
     */
    public function setPartidaDUA($partidaDUA = null)
    {
        // validation for constraint: string
        if (!is_null($partidaDUA) && !is_string($partidaDUA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partidaDUA, true), gettype($partidaDUA)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($partidaDUA) && mb_strlen($partidaDUA) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($partidaDUA)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partidaDUA) && mb_strlen($partidaDUA) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partidaDUA)), __LINE__);
        }
        $this->PartidaDUA = $partidaDUA;
        return $this;
    }
}
