<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsCertV3Sal StructType
 * Meta information extracted from the WSDL
 * - type: ConsCertV3Sal
 * @subpackage Structs
 */
class ConsCertV3Sal extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - documentation: Identificador de transaccion. Se respondera con el Id de la petición a la que se responde | Identificador de transaccion. Debe ser unico Se sugiere utilizar TimeStamp del tipo AAAAMMDDHHMMSSNNNNNN, aunque puede ser cualquiera
     * mientras que la Administración origen garantice la unicidad
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $Id;
    /**
     * The ConsCertifRea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConsCertifReaTipo
     */
    public $ConsCertifRea;
    /**
     * The Rechazos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RechazosTipo
     */
    public $Rechazos;
    /**
     * Constructor method for ConsCertV3Sal
     * @uses ConsCertV3Sal::setId()
     * @uses ConsCertV3Sal::setConsCertifRea()
     * @uses ConsCertV3Sal::setRechazos()
     * @param string $id
     * @param \StructType\ConsCertifReaTipo $consCertifRea
     * @param \StructType\RechazosTipo $rechazos
     */
    public function __construct($id = null, \StructType\ConsCertifReaTipo $consCertifRea = null, \StructType\RechazosTipo $rechazos = null)
    {
        $this
            ->setId($id)
            ->setConsCertifRea($consCertifRea)
            ->setRechazos($rechazos);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ConsCertV3Sal
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($id) && mb_strlen($id) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ConsCertifRea value
     * @return \StructType\ConsCertifReaTipo|null
     */
    public function getConsCertifRea()
    {
        return $this->ConsCertifRea;
    }
    /**
     * Set ConsCertifRea value
     * @param \StructType\ConsCertifReaTipo $consCertifRea
     * @return \StructType\ConsCertV3Sal
     */
    public function setConsCertifRea(\StructType\ConsCertifReaTipo $consCertifRea = null)
    {
        $this->ConsCertifRea = $consCertifRea;
        return $this;
    }
    /**
     * Get Rechazos value
     * @return \StructType\RechazosTipo|null
     */
    public function getRechazos()
    {
        return $this->Rechazos;
    }
    /**
     * Set Rechazos value
     * @param \StructType\RechazosTipo $rechazos
     * @return \StructType\ConsCertV3Sal
     */
    public function setRechazos(\StructType\RechazosTipo $rechazos = null)
    {
        $this->Rechazos = $rechazos;
        return $this;
    }
}
