<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsCertV3Ent StructType
 * Meta information extracted from the WSDL
 * - type: ConsCertV3Ent
 * @subpackage Structs
 */
class ConsCertV3Ent extends AbstractStructBase
{
    /**
     * The ConsCert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ConsCertTipo
     */
    public $ConsCert;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - documentation: Identificador de transaccion. Debe ser único. Se sugiere utilizar TimeStamp del tipo AAAAMMDDHHMMSSNNNNNN | Identificador de transaccion. Debe ser unico Se sugiere utilizar TimeStamp del tipo AAAAMMDDHHMMSSNNNNNN, aunque puede ser
     * cualquiera mientras que la Administración origen garantice la unicidad
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ConsCertV3Ent
     * @uses ConsCertV3Ent::setConsCert()
     * @uses ConsCertV3Ent::setId()
     * @param \StructType\ConsCertTipo $consCert
     * @param string $id
     */
    public function __construct(\StructType\ConsCertTipo $consCert = null, $id = null)
    {
        $this
            ->setConsCert($consCert)
            ->setId($id);
    }
    /**
     * Get ConsCert value
     * @return \StructType\ConsCertTipo
     */
    public function getConsCert()
    {
        return $this->ConsCert;
    }
    /**
     * Set ConsCert value
     * @param \StructType\ConsCertTipo $consCert
     * @return \StructType\ConsCertV3Ent
     */
    public function setConsCert(\StructType\ConsCertTipo $consCert = null)
    {
        $this->ConsCert = $consCert;
        return $this;
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ConsCertV3Ent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($id) && mb_strlen($id) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
