<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsCertTipo StructType
 * @subpackage Structs
 */
class ConsCertTipo extends AbstractStructBase
{
    /**
     * The Certificado
     * Meta information extracted from the WSDL
     * - documentation: Código del certificado REA a eliminar. | Número de certificado REA (usado en importación).
     * - base: xs:string
     * - length: 12
     * @var string
     */
    public $Certificado;
    /**
     * Constructor method for ConsCertTipo
     * @uses ConsCertTipo::setCertificado()
     * @param string $certificado
     */
    public function __construct($certificado = null)
    {
        $this
            ->setCertificado($certificado);
    }
    /**
     * Get Certificado value
     * @return string|null
     */
    public function getCertificado()
    {
        return $this->Certificado;
    }
    /**
     * Set Certificado value
     * @param string $certificado
     * @return \StructType\ConsCertTipo
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        // validation for constraint: length(12)
        if (!is_null($certificado) && mb_strlen($certificado) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 12', mb_strlen($certificado)), __LINE__);
        }
        $this->Certificado = $certificado;
        return $this;
    }
}
