<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lista ServiceType
 * @subpackage Services
 */
class Lista extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListaDecV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDecV4Ent $listaDecV4Ent
     * @return \StructType\ListaDecV4Sal|bool
     */
    public function ListaDecV4(\StructType\ListaDecV4Ent $listaDecV4Ent)
    {
        try {
            $this->setResult($this->getSoapClient()->ListaDecV4($listaDecV4Ent));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListaDecV4Sal
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
