<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for declaranteType StructType
 * Meta information extracted from the WSDL
 * - documentation: declaranteType: Información del declarante, de la persona en cuyo nombre se presenta la declaración. NifDeclarante: Nif del declarante NombreDeclarante: Nombre del declarante
 * @subpackage Structs
 */
class DeclaranteType extends AbstractStructBase
{
    /**
     * The NifDeclarante
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NifDeclarante;
    /**
     * The NombreDeclarante
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NombreDeclarante;
    /**
     * Constructor method for declaranteType
     * @uses DeclaranteType::setNifDeclarante()
     * @uses DeclaranteType::setNombreDeclarante()
     * @param string $nifDeclarante
     * @param string $nombreDeclarante
     */
    public function __construct($nifDeclarante = null, $nombreDeclarante = null)
    {
        $this
            ->setNifDeclarante($nifDeclarante)
            ->setNombreDeclarante($nombreDeclarante);
    }
    /**
     * Get NifDeclarante value
     * @return string
     */
    public function getNifDeclarante()
    {
        return $this->NifDeclarante;
    }
    /**
     * Set NifDeclarante value
     * @param string $nifDeclarante
     * @return \StructType\DeclaranteType
     */
    public function setNifDeclarante($nifDeclarante = null)
    {
        // validation for constraint: string
        if (!is_null($nifDeclarante) && !is_string($nifDeclarante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nifDeclarante, true), gettype($nifDeclarante)), __LINE__);
        }
        $this->NifDeclarante = $nifDeclarante;
        return $this;
    }
    /**
     * Get NombreDeclarante value
     * @return string
     */
    public function getNombreDeclarante()
    {
        return $this->NombreDeclarante;
    }
    /**
     * Set NombreDeclarante value
     * @param string $nombreDeclarante
     * @return \StructType\DeclaranteType
     */
    public function setNombreDeclarante($nombreDeclarante = null)
    {
        // validation for constraint: string
        if (!is_null($nombreDeclarante) && !is_string($nombreDeclarante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreDeclarante, true), gettype($nombreDeclarante)), __LINE__);
        }
        $this->NombreDeclarante = $nombreDeclarante;
        return $this;
    }
}
