<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for declaracionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Información necesaria para recuperar una declaración pendiente de leer de la Bandeja de Entrada. clave: Clave que identifica univocamente cada respuesta. referencia: Referencia del mensaje. Coincide con el valor del campo ID del
 * mensaje de petición. tipoRespuesta: Tipo de respuesta. Está en función del tipo de Servicio Web utilizado.
 * @subpackage Structs
 */
class DeclaracionType extends AbstractStructBase
{
    /**
     * The clave
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $clave;
    /**
     * The referencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $referencia;
    /**
     * The tipoRespuesta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoRespuesta;
    /**
     * Constructor method for declaracionType
     * @uses DeclaracionType::setClave()
     * @uses DeclaracionType::setReferencia()
     * @uses DeclaracionType::setTipoRespuesta()
     * @param string $clave
     * @param string $referencia
     * @param string $tipoRespuesta
     */
    public function __construct($clave = null, $referencia = null, $tipoRespuesta = null)
    {
        $this
            ->setClave($clave)
            ->setReferencia($referencia)
            ->setTipoRespuesta($tipoRespuesta);
    }
    /**
     * Get clave value
     * @return string
     */
    public function getClave()
    {
        return $this->clave;
    }
    /**
     * Set clave value
     * @param string $clave
     * @return \StructType\DeclaracionType
     */
    public function setClave($clave = null)
    {
        // validation for constraint: string
        if (!is_null($clave) && !is_string($clave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clave, true), gettype($clave)), __LINE__);
        }
        $this->clave = $clave;
        return $this;
    }
    /**
     * Get referencia value
     * @return string
     */
    public function getReferencia()
    {
        return $this->referencia;
    }
    /**
     * Set referencia value
     * @param string $referencia
     * @return \StructType\DeclaracionType
     */
    public function setReferencia($referencia = null)
    {
        // validation for constraint: string
        if (!is_null($referencia) && !is_string($referencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencia, true), gettype($referencia)), __LINE__);
        }
        $this->referencia = $referencia;
        return $this;
    }
    /**
     * Get tipoRespuesta value
     * @return string
     */
    public function getTipoRespuesta()
    {
        return $this->tipoRespuesta;
    }
    /**
     * Set tipoRespuesta value
     * @param string $tipoRespuesta
     * @return \StructType\DeclaracionType
     */
    public function setTipoRespuesta($tipoRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRespuesta) && !is_string($tipoRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoRespuesta, true), gettype($tipoRespuesta)), __LINE__);
        }
        $this->tipoRespuesta = $tipoRespuesta;
        return $this;
    }
}
