<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseDesc;
    /**
     * The ResponseData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseData;
    /**
     * Constructor method for Response
     * @uses Response::setResponseCode()
     * @uses Response::setResponseDesc()
     * @uses Response::setResponseData()
     * @param string $responseCode
     * @param string $responseDesc
     * @param string $responseData
     */
    public function __construct($responseCode = null, $responseDesc = null, $responseData = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setResponseDesc($responseDesc)
            ->setResponseData($responseData);
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\Response
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ResponseDesc value
     * @return string|null
     */
    public function getResponseDesc()
    {
        return $this->ResponseDesc;
    }
    /**
     * Set ResponseDesc value
     * @param string $responseDesc
     * @return \StructType\Response
     */
    public function setResponseDesc($responseDesc = null)
    {
        // validation for constraint: string
        if (!is_null($responseDesc) && !is_string($responseDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseDesc)), __LINE__);
        }
        $this->ResponseDesc = $responseDesc;
        return $this;
    }
    /**
     * Get ResponseData value
     * @return string|null
     */
    public function getResponseData()
    {
        return $this->ResponseData;
    }
    /**
     * Set ResponseData value
     * @param string $responseData
     * @return \StructType\Response
     */
    public function setResponseData($responseData = null)
    {
        // validation for constraint: string
        if (!is_null($responseData) && !is_string($responseData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseData)), __LINE__);
        }
        $this->ResponseData = $responseData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
