<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The from_currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $from_currency;
    /**
     * The fx_rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fx_rate;
    /**
     * The partner_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner_code;
    /**
     * The time_stamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $time_stamp;
    /**
     * The to_currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $to_currency;
    /**
     * Constructor method for Rate
     * @uses Rate::setFrom_currency()
     * @uses Rate::setFx_rate()
     * @uses Rate::setPartner_code()
     * @uses Rate::setTime_stamp()
     * @uses Rate::setTo_currency()
     * @param string $from_currency
     * @param float $fx_rate
     * @param string $partner_code
     * @param string $time_stamp
     * @param string $to_currency
     */
    public function __construct($from_currency = null, $fx_rate = null, $partner_code = null, $time_stamp = null, $to_currency = null)
    {
        $this
            ->setFrom_currency($from_currency)
            ->setFx_rate($fx_rate)
            ->setPartner_code($partner_code)
            ->setTime_stamp($time_stamp)
            ->setTo_currency($to_currency);
    }
    /**
     * Get from_currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom_currency()
    {
        return isset($this->from_currency) ? $this->from_currency : null;
    }
    /**
     * Set from_currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from_currency
     * @return \StructType\Rate
     */
    public function setFrom_currency($from_currency = null)
    {
        // validation for constraint: string
        if (!is_null($from_currency) && !is_string($from_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_currency, true), gettype($from_currency)), __LINE__);
        }
        if (is_null($from_currency) || (is_array($from_currency) && empty($from_currency))) {
            unset($this->from_currency);
        } else {
            $this->from_currency = $from_currency;
        }
        return $this;
    }
    /**
     * Get fx_rate value
     * @return float|null
     */
    public function getFx_rate()
    {
        return $this->fx_rate;
    }
    /**
     * Set fx_rate value
     * @param float $fx_rate
     * @return \StructType\Rate
     */
    public function setFx_rate($fx_rate = null)
    {
        // validation for constraint: float
        if (!is_null($fx_rate) && !(is_float($fx_rate) || is_numeric($fx_rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fx_rate, true), gettype($fx_rate)), __LINE__);
        }
        $this->fx_rate = $fx_rate;
        return $this;
    }
    /**
     * Get partner_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner_code()
    {
        return isset($this->partner_code) ? $this->partner_code : null;
    }
    /**
     * Set partner_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner_code
     * @return \StructType\Rate
     */
    public function setPartner_code($partner_code = null)
    {
        // validation for constraint: string
        if (!is_null($partner_code) && !is_string($partner_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_code, true), gettype($partner_code)), __LINE__);
        }
        if (is_null($partner_code) || (is_array($partner_code) && empty($partner_code))) {
            unset($this->partner_code);
        } else {
            $this->partner_code = $partner_code;
        }
        return $this;
    }
    /**
     * Get time_stamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTime_stamp()
    {
        return isset($this->time_stamp) ? $this->time_stamp : null;
    }
    /**
     * Set time_stamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $time_stamp
     * @return \StructType\Rate
     */
    public function setTime_stamp($time_stamp = null)
    {
        // validation for constraint: string
        if (!is_null($time_stamp) && !is_string($time_stamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_stamp, true), gettype($time_stamp)), __LINE__);
        }
        if (is_null($time_stamp) || (is_array($time_stamp) && empty($time_stamp))) {
            unset($this->time_stamp);
        } else {
            $this->time_stamp = $time_stamp;
        }
        return $this;
    }
    /**
     * Get to_currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTo_currency()
    {
        return isset($this->to_currency) ? $this->to_currency : null;
    }
    /**
     * Set to_currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $to_currency
     * @return \StructType\Rate
     */
    public function setTo_currency($to_currency = null)
    {
        // validation for constraint: string
        if (!is_null($to_currency) && !is_string($to_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_currency, true), gettype($to_currency)), __LINE__);
        }
        if (is_null($to_currency) || (is_array($to_currency) && empty($to_currency))) {
            unset($this->to_currency);
        } else {
            $this->to_currency = $to_currency;
        }
        return $this;
    }
}
