<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partner StructType
 * @subpackage Structs
 */
class Partner extends AbstractStructBase
{
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_code;
    /**
     * The currency_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency_code;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Limit
     */
    public $limit;
    /**
     * The partner_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner_code;
    /**
     * The partner_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner_name;
    /**
     * Constructor method for Partner
     * @uses Partner::setCountry_code()
     * @uses Partner::setCurrency_code()
     * @uses Partner::setLimit()
     * @uses Partner::setPartner_code()
     * @uses Partner::setPartner_name()
     * @param string $country_code
     * @param string $currency_code
     * @param \StructType\Limit $limit
     * @param string $partner_code
     * @param string $partner_name
     */
    public function __construct($country_code = null, $currency_code = null, \StructType\Limit $limit = null, $partner_code = null, $partner_name = null)
    {
        $this
            ->setCountry_code($country_code)
            ->setCurrency_code($currency_code)
            ->setLimit($limit)
            ->setPartner_code($partner_code)
            ->setPartner_name($partner_name);
    }
    /**
     * Get country_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_code()
    {
        return isset($this->country_code) ? $this->country_code : null;
    }
    /**
     * Set country_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_code
     * @return \StructType\Partner
     */
    public function setCountry_code($country_code = null)
    {
        // validation for constraint: string
        if (!is_null($country_code) && !is_string($country_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_code, true), gettype($country_code)), __LINE__);
        }
        if (is_null($country_code) || (is_array($country_code) && empty($country_code))) {
            unset($this->country_code);
        } else {
            $this->country_code = $country_code;
        }
        return $this;
    }
    /**
     * Get currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency_code()
    {
        return isset($this->currency_code) ? $this->currency_code : null;
    }
    /**
     * Set currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency_code
     * @return \StructType\Partner
     */
    public function setCurrency_code($currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($currency_code) && !is_string($currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_code, true), gettype($currency_code)), __LINE__);
        }
        if (is_null($currency_code) || (is_array($currency_code) && empty($currency_code))) {
            unset($this->currency_code);
        } else {
            $this->currency_code = $currency_code;
        }
        return $this;
    }
    /**
     * Get limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Limit|null
     */
    public function getLimit()
    {
        return isset($this->limit) ? $this->limit : null;
    }
    /**
     * Set limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Limit $limit
     * @return \StructType\Partner
     */
    public function setLimit(\StructType\Limit $limit = null)
    {
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->limit);
        } else {
            $this->limit = $limit;
        }
        return $this;
    }
    /**
     * Get partner_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner_code()
    {
        return isset($this->partner_code) ? $this->partner_code : null;
    }
    /**
     * Set partner_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner_code
     * @return \StructType\Partner
     */
    public function setPartner_code($partner_code = null)
    {
        // validation for constraint: string
        if (!is_null($partner_code) && !is_string($partner_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_code, true), gettype($partner_code)), __LINE__);
        }
        if (is_null($partner_code) || (is_array($partner_code) && empty($partner_code))) {
            unset($this->partner_code);
        } else {
            $this->partner_code = $partner_code;
        }
        return $this;
    }
    /**
     * Get partner_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner_name()
    {
        return isset($this->partner_name) ? $this->partner_name : null;
    }
    /**
     * Set partner_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner_name
     * @return \StructType\Partner
     */
    public function setPartner_name($partner_name = null)
    {
        // validation for constraint: string
        if (!is_null($partner_name) && !is_string($partner_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_name, true), gettype($partner_name)), __LINE__);
        }
        if (is_null($partner_name) || (is_array($partner_name) && empty($partner_name))) {
            unset($this->partner_name);
        } else {
            $this->partner_name = $partner_name;
        }
        return $this;
    }
}
