<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccount StructType
 * @subpackage Structs
 */
class BankAccount extends AbstractStructBase
{
    /**
     * The account_holder_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $account_holder_name;
    /**
     * The account_number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $account_number;
    /**
     * The mfs_bank_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_bank_code;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Code
     */
    public $status;
    /**
     * Constructor method for BankAccount
     * @uses BankAccount::setAccount_holder_name()
     * @uses BankAccount::setAccount_number()
     * @uses BankAccount::setMfs_bank_code()
     * @uses BankAccount::setStatus()
     * @param string $account_holder_name
     * @param string $account_number
     * @param string $mfs_bank_code
     * @param \StructType\Code $status
     */
    public function __construct($account_holder_name = null, $account_number = null, $mfs_bank_code = null, \StructType\Code $status = null)
    {
        $this
            ->setAccount_holder_name($account_holder_name)
            ->setAccount_number($account_number)
            ->setMfs_bank_code($mfs_bank_code)
            ->setStatus($status);
    }
    /**
     * Get account_holder_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccount_holder_name()
    {
        return isset($this->account_holder_name) ? $this->account_holder_name : null;
    }
    /**
     * Set account_holder_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $account_holder_name
     * @return \StructType\BankAccount
     */
    public function setAccount_holder_name($account_holder_name = null)
    {
        // validation for constraint: string
        if (!is_null($account_holder_name) && !is_string($account_holder_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_holder_name, true), gettype($account_holder_name)), __LINE__);
        }
        if (is_null($account_holder_name) || (is_array($account_holder_name) && empty($account_holder_name))) {
            unset($this->account_holder_name);
        } else {
            $this->account_holder_name = $account_holder_name;
        }
        return $this;
    }
    /**
     * Get account_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccount_number()
    {
        return isset($this->account_number) ? $this->account_number : null;
    }
    /**
     * Set account_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $account_number
     * @return \StructType\BankAccount
     */
    public function setAccount_number($account_number = null)
    {
        // validation for constraint: string
        if (!is_null($account_number) && !is_string($account_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_number, true), gettype($account_number)), __LINE__);
        }
        if (is_null($account_number) || (is_array($account_number) && empty($account_number))) {
            unset($this->account_number);
        } else {
            $this->account_number = $account_number;
        }
        return $this;
    }
    /**
     * Get mfs_bank_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_bank_code()
    {
        return isset($this->mfs_bank_code) ? $this->mfs_bank_code : null;
    }
    /**
     * Set mfs_bank_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_bank_code
     * @return \StructType\BankAccount
     */
    public function setMfs_bank_code($mfs_bank_code = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_bank_code) && !is_string($mfs_bank_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_bank_code, true), gettype($mfs_bank_code)), __LINE__);
        }
        if (is_null($mfs_bank_code) || (is_array($mfs_bank_code) && empty($mfs_bank_code))) {
            unset($this->mfs_bank_code);
        } else {
            $this->mfs_bank_code = $mfs_bank_code;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Code|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Code $status
     * @return \StructType\BankAccount
     */
    public function setStatus(\StructType\Code $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
}
