<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bank StructType
 * @subpackage Structs
 */
class Bank extends AbstractStructBase
{
    /**
     * The bank_limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Limit
     */
    public $bank_limit;
    /**
     * The bank_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bank_name;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bic;
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_code;
    /**
     * The currency_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency_code;
    /**
     * The dom_bank_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dom_bank_code;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $iban;
    /**
     * The mfs_bank_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_bank_code;
    /**
     * Constructor method for Bank
     * @uses Bank::setBank_limit()
     * @uses Bank::setBank_name()
     * @uses Bank::setBic()
     * @uses Bank::setCountry_code()
     * @uses Bank::setCurrency_code()
     * @uses Bank::setDom_bank_code()
     * @uses Bank::setIban()
     * @uses Bank::setMfs_bank_code()
     * @param \StructType\Limit $bank_limit
     * @param string $bank_name
     * @param string $bic
     * @param string $country_code
     * @param string $currency_code
     * @param string $dom_bank_code
     * @param string $iban
     * @param string $mfs_bank_code
     */
    public function __construct(\StructType\Limit $bank_limit = null, $bank_name = null, $bic = null, $country_code = null, $currency_code = null, $dom_bank_code = null, $iban = null, $mfs_bank_code = null)
    {
        $this
            ->setBank_limit($bank_limit)
            ->setBank_name($bank_name)
            ->setBic($bic)
            ->setCountry_code($country_code)
            ->setCurrency_code($currency_code)
            ->setDom_bank_code($dom_bank_code)
            ->setIban($iban)
            ->setMfs_bank_code($mfs_bank_code);
    }
    /**
     * Get bank_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Limit|null
     */
    public function getBank_limit()
    {
        return isset($this->bank_limit) ? $this->bank_limit : null;
    }
    /**
     * Set bank_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Limit $bank_limit
     * @return \StructType\Bank
     */
    public function setBank_limit(\StructType\Limit $bank_limit = null)
    {
        if (is_null($bank_limit) || (is_array($bank_limit) && empty($bank_limit))) {
            unset($this->bank_limit);
        } else {
            $this->bank_limit = $bank_limit;
        }
        return $this;
    }
    /**
     * Get bank_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBank_name()
    {
        return isset($this->bank_name) ? $this->bank_name : null;
    }
    /**
     * Set bank_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bank_name
     * @return \StructType\Bank
     */
    public function setBank_name($bank_name = null)
    {
        // validation for constraint: string
        if (!is_null($bank_name) && !is_string($bank_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_name, true), gettype($bank_name)), __LINE__);
        }
        if (is_null($bank_name) || (is_array($bank_name) && empty($bank_name))) {
            unset($this->bank_name);
        } else {
            $this->bank_name = $bank_name;
        }
        return $this;
    }
    /**
     * Get bic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBic()
    {
        return isset($this->bic) ? $this->bic : null;
    }
    /**
     * Set bic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bic
     * @return \StructType\Bank
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        if (is_null($bic) || (is_array($bic) && empty($bic))) {
            unset($this->bic);
        } else {
            $this->bic = $bic;
        }
        return $this;
    }
    /**
     * Get country_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_code()
    {
        return isset($this->country_code) ? $this->country_code : null;
    }
    /**
     * Set country_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_code
     * @return \StructType\Bank
     */
    public function setCountry_code($country_code = null)
    {
        // validation for constraint: string
        if (!is_null($country_code) && !is_string($country_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_code, true), gettype($country_code)), __LINE__);
        }
        if (is_null($country_code) || (is_array($country_code) && empty($country_code))) {
            unset($this->country_code);
        } else {
            $this->country_code = $country_code;
        }
        return $this;
    }
    /**
     * Get currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency_code()
    {
        return isset($this->currency_code) ? $this->currency_code : null;
    }
    /**
     * Set currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency_code
     * @return \StructType\Bank
     */
    public function setCurrency_code($currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($currency_code) && !is_string($currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_code, true), gettype($currency_code)), __LINE__);
        }
        if (is_null($currency_code) || (is_array($currency_code) && empty($currency_code))) {
            unset($this->currency_code);
        } else {
            $this->currency_code = $currency_code;
        }
        return $this;
    }
    /**
     * Get dom_bank_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDom_bank_code()
    {
        return isset($this->dom_bank_code) ? $this->dom_bank_code : null;
    }
    /**
     * Set dom_bank_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dom_bank_code
     * @return \StructType\Bank
     */
    public function setDom_bank_code($dom_bank_code = null)
    {
        // validation for constraint: string
        if (!is_null($dom_bank_code) && !is_string($dom_bank_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dom_bank_code, true), gettype($dom_bank_code)), __LINE__);
        }
        if (is_null($dom_bank_code) || (is_array($dom_bank_code) && empty($dom_bank_code))) {
            unset($this->dom_bank_code);
        } else {
            $this->dom_bank_code = $dom_bank_code;
        }
        return $this;
    }
    /**
     * Get iban value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIban()
    {
        return isset($this->iban) ? $this->iban : null;
    }
    /**
     * Set iban value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iban
     * @return \StructType\Bank
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        if (is_null($iban) || (is_array($iban) && empty($iban))) {
            unset($this->iban);
        } else {
            $this->iban = $iban;
        }
        return $this;
    }
    /**
     * Get mfs_bank_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_bank_code()
    {
        return isset($this->mfs_bank_code) ? $this->mfs_bank_code : null;
    }
    /**
     * Set mfs_bank_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_bank_code
     * @return \StructType\Bank
     */
    public function setMfs_bank_code($mfs_bank_code = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_bank_code) && !is_string($mfs_bank_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_bank_code, true), gettype($mfs_bank_code)), __LINE__);
        }
        if (is_null($mfs_bank_code) || (is_array($mfs_bank_code) && empty($mfs_bank_code))) {
            unset($this->mfs_bank_code);
        } else {
            $this->mfs_bank_code = $mfs_bank_code;
        }
        return $this;
    }
}
