<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getrate ServiceType
 * @subpackage Services
 */
class Getrate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_rate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_rate $parameters
     * @return \StructType\Get_rateResponse|bool
     */
    public function get_rate(\StructType\Get_rate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->get_rate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_rateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
