<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getbanks ServiceType
 * @subpackage Services
 */
class Getbanks extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_banks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_banks $parameters
     * @return \StructType\Get_banksResponse|bool
     */
    public function get_banks(\StructType\Get_banks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->get_banks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_banksResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
