<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelvoucher ServiceType
 * @subpackage Services
 */
class Cancelvoucher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancel_voucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_voucher $parameters
     * @return \StructType\Cancel_voucherResponse|bool
     */
    public function cancel_voucher(\StructType\Cancel_voucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cancel_voucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Cancel_voucherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
