<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Code
     */
    public $code;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The mfs_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_trans_id;
    /**
     * The receive_partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $receive_partner;
    /**
     * The voucher_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voucher_code;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setCode()
     * @uses Voucher::setMessage()
     * @uses Voucher::setMfs_trans_id()
     * @uses Voucher::setReceive_partner()
     * @uses Voucher::setVoucher_code()
     * @param \StructType\Code $code
     * @param string $message
     * @param string $mfs_trans_id
     * @param string $receive_partner
     * @param string $voucher_code
     */
    public function __construct(\StructType\Code $code = null, $message = null, $mfs_trans_id = null, $receive_partner = null, $voucher_code = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setMfs_trans_id($mfs_trans_id)
            ->setReceive_partner($receive_partner)
            ->setVoucher_code($voucher_code);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Code|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Code $code
     * @return \StructType\Voucher
     */
    public function setCode(\StructType\Code $code = null)
    {
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->message) ? $this->message : null;
    }
    /**
     * Set message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\Voucher
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->message);
        } else {
            $this->message = $message;
        }
        return $this;
    }
    /**
     * Get mfs_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_trans_id()
    {
        return isset($this->mfs_trans_id) ? $this->mfs_trans_id : null;
    }
    /**
     * Set mfs_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_trans_id
     * @return \StructType\Voucher
     */
    public function setMfs_trans_id($mfs_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_trans_id) && !is_string($mfs_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_trans_id, true), gettype($mfs_trans_id)), __LINE__);
        }
        if (is_null($mfs_trans_id) || (is_array($mfs_trans_id) && empty($mfs_trans_id))) {
            unset($this->mfs_trans_id);
        } else {
            $this->mfs_trans_id = $mfs_trans_id;
        }
        return $this;
    }
    /**
     * Get receive_partner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceive_partner()
    {
        return isset($this->receive_partner) ? $this->receive_partner : null;
    }
    /**
     * Set receive_partner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receive_partner
     * @return \StructType\Voucher
     */
    public function setReceive_partner($receive_partner = null)
    {
        // validation for constraint: string
        if (!is_null($receive_partner) && !is_string($receive_partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receive_partner, true), gettype($receive_partner)), __LINE__);
        }
        if (is_null($receive_partner) || (is_array($receive_partner) && empty($receive_partner))) {
            unset($this->receive_partner);
        } else {
            $this->receive_partner = $receive_partner;
        }
        return $this;
    }
    /**
     * Get voucher_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucher_code()
    {
        return isset($this->voucher_code) ? $this->voucher_code : null;
    }
    /**
     * Set voucher_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucher_code
     * @return \StructType\Voucher
     */
    public function setVoucher_code($voucher_code = null)
    {
        // validation for constraint: string
        if (!is_null($voucher_code) && !is_string($voucher_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher_code, true), gettype($voucher_code)), __LINE__);
        }
        if (is_null($voucher_code) || (is_array($voucher_code) && empty($voucher_code))) {
            unset($this->voucher_code);
        } else {
            $this->voucher_code = $voucher_code;
        }
        return $this;
    }
}
