<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionAirtime StructType
 * @subpackage Structs
 */
class TransactionAirtime extends AbstractStructBase
{
    /**
     * The airtime_fx_rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $airtime_fx_rate;
    /**
     * The fee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $fee;
    /**
     * The mfs_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_trans_id;
    /**
     * The receive_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $receive_amount;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The third_party_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $third_party_trans_id;
    /**
     * Constructor method for TransactionAirtime
     * @uses TransactionAirtime::setAirtime_fx_rate()
     * @uses TransactionAirtime::setFee()
     * @uses TransactionAirtime::setMfs_trans_id()
     * @uses TransactionAirtime::setReceive_amount()
     * @uses TransactionAirtime::setReference()
     * @uses TransactionAirtime::setThird_party_trans_id()
     * @param float $airtime_fx_rate
     * @param \StructType\Money $fee
     * @param string $mfs_trans_id
     * @param \StructType\Money $receive_amount
     * @param string $reference
     * @param string $third_party_trans_id
     */
    public function __construct($airtime_fx_rate = null, \StructType\Money $fee = null, $mfs_trans_id = null, \StructType\Money $receive_amount = null, $reference = null, $third_party_trans_id = null)
    {
        $this
            ->setAirtime_fx_rate($airtime_fx_rate)
            ->setFee($fee)
            ->setMfs_trans_id($mfs_trans_id)
            ->setReceive_amount($receive_amount)
            ->setReference($reference)
            ->setThird_party_trans_id($third_party_trans_id);
    }
    /**
     * Get airtime_fx_rate value
     * @return float|null
     */
    public function getAirtime_fx_rate()
    {
        return $this->airtime_fx_rate;
    }
    /**
     * Set airtime_fx_rate value
     * @param float $airtime_fx_rate
     * @return \StructType\TransactionAirtime
     */
    public function setAirtime_fx_rate($airtime_fx_rate = null)
    {
        // validation for constraint: float
        if (!is_null($airtime_fx_rate) && !(is_float($airtime_fx_rate) || is_numeric($airtime_fx_rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($airtime_fx_rate, true), gettype($airtime_fx_rate)), __LINE__);
        }
        $this->airtime_fx_rate = $airtime_fx_rate;
        return $this;
    }
    /**
     * Get fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getFee()
    {
        return isset($this->fee) ? $this->fee : null;
    }
    /**
     * Set fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $fee
     * @return \StructType\TransactionAirtime
     */
    public function setFee(\StructType\Money $fee = null)
    {
        if (is_null($fee) || (is_array($fee) && empty($fee))) {
            unset($this->fee);
        } else {
            $this->fee = $fee;
        }
        return $this;
    }
    /**
     * Get mfs_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_trans_id()
    {
        return isset($this->mfs_trans_id) ? $this->mfs_trans_id : null;
    }
    /**
     * Set mfs_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_trans_id
     * @return \StructType\TransactionAirtime
     */
    public function setMfs_trans_id($mfs_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_trans_id) && !is_string($mfs_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_trans_id, true), gettype($mfs_trans_id)), __LINE__);
        }
        if (is_null($mfs_trans_id) || (is_array($mfs_trans_id) && empty($mfs_trans_id))) {
            unset($this->mfs_trans_id);
        } else {
            $this->mfs_trans_id = $mfs_trans_id;
        }
        return $this;
    }
    /**
     * Get receive_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getReceive_amount()
    {
        return isset($this->receive_amount) ? $this->receive_amount : null;
    }
    /**
     * Set receive_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $receive_amount
     * @return \StructType\TransactionAirtime
     */
    public function setReceive_amount(\StructType\Money $receive_amount = null)
    {
        if (is_null($receive_amount) || (is_array($receive_amount) && empty($receive_amount))) {
            unset($this->receive_amount);
        } else {
            $this->receive_amount = $receive_amount;
        }
        return $this;
    }
    /**
     * Get reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->reference) ? $this->reference : null;
    }
    /**
     * Set reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\TransactionAirtime
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->reference);
        } else {
            $this->reference = $reference;
        }
        return $this;
    }
    /**
     * Get third_party_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThird_party_trans_id()
    {
        return isset($this->third_party_trans_id) ? $this->third_party_trans_id : null;
    }
    /**
     * Set third_party_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $third_party_trans_id
     * @return \StructType\TransactionAirtime
     */
    public function setThird_party_trans_id($third_party_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($third_party_trans_id) && !is_string($third_party_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($third_party_trans_id, true), gettype($third_party_trans_id)), __LINE__);
        }
        if (is_null($third_party_trans_id) || (is_array($third_party_trans_id) && empty($third_party_trans_id))) {
            unset($this->third_party_trans_id);
        } else {
            $this->third_party_trans_id = $third_party_trans_id;
        }
        return $this;
    }
}
