<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeRange StructType
 * @subpackage Structs
 */
class FreeRange extends AbstractStructBase
{
    /**
     * The max_receive_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_receive_amount;
    /**
     * The min_receive_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $min_receive_amount;
    /**
     * Constructor method for FreeRange
     * @uses FreeRange::setMax_receive_amount()
     * @uses FreeRange::setMin_receive_amount()
     * @param float $max_receive_amount
     * @param float $min_receive_amount
     */
    public function __construct($max_receive_amount = null, $min_receive_amount = null)
    {
        $this
            ->setMax_receive_amount($max_receive_amount)
            ->setMin_receive_amount($min_receive_amount);
    }
    /**
     * Get max_receive_amount value
     * @return float|null
     */
    public function getMax_receive_amount()
    {
        return $this->max_receive_amount;
    }
    /**
     * Set max_receive_amount value
     * @param float $max_receive_amount
     * @return \StructType\FreeRange
     */
    public function setMax_receive_amount($max_receive_amount = null)
    {
        // validation for constraint: float
        if (!is_null($max_receive_amount) && !(is_float($max_receive_amount) || is_numeric($max_receive_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_receive_amount, true), gettype($max_receive_amount)), __LINE__);
        }
        $this->max_receive_amount = $max_receive_amount;
        return $this;
    }
    /**
     * Get min_receive_amount value
     * @return float|null
     */
    public function getMin_receive_amount()
    {
        return $this->min_receive_amount;
    }
    /**
     * Set min_receive_amount value
     * @param float $min_receive_amount
     * @return \StructType\FreeRange
     */
    public function setMin_receive_amount($min_receive_amount = null)
    {
        // validation for constraint: float
        if (!is_null($min_receive_amount) && !(is_float($min_receive_amount) || is_numeric($min_receive_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($min_receive_amount, true), gettype($min_receive_amount)), __LINE__);
        }
        $this->min_receive_amount = $min_receive_amount;
        return $this;
    }
}
