<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account extends AbstractStructBase
{
    /**
     * The account_number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $account_number;
    /**
     * The mfs_bank_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_bank_code;
    /**
     * Constructor method for Account
     * @uses Account::setAccount_number()
     * @uses Account::setMfs_bank_code()
     * @param string $account_number
     * @param string $mfs_bank_code
     */
    public function __construct($account_number = null, $mfs_bank_code = null)
    {
        $this
            ->setAccount_number($account_number)
            ->setMfs_bank_code($mfs_bank_code);
    }
    /**
     * Get account_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccount_number()
    {
        return isset($this->account_number) ? $this->account_number : null;
    }
    /**
     * Set account_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $account_number
     * @return \StructType\Account
     */
    public function setAccount_number($account_number = null)
    {
        // validation for constraint: string
        if (!is_null($account_number) && !is_string($account_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_number, true), gettype($account_number)), __LINE__);
        }
        if (is_null($account_number) || (is_array($account_number) && empty($account_number))) {
            unset($this->account_number);
        } else {
            $this->account_number = $account_number;
        }
        return $this;
    }
    /**
     * Get mfs_bank_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_bank_code()
    {
        return isset($this->mfs_bank_code) ? $this->mfs_bank_code : null;
    }
    /**
     * Set mfs_bank_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_bank_code
     * @return \StructType\Account
     */
    public function setMfs_bank_code($mfs_bank_code = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_bank_code) && !is_string($mfs_bank_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_bank_code, true), gettype($mfs_bank_code)), __LINE__);
        }
        if (is_null($mfs_bank_code) || (is_array($mfs_bank_code) && empty($mfs_bank_code))) {
            unset($this->mfs_bank_code);
        } else {
            $this->mfs_bank_code = $mfs_bank_code;
        }
        return $this;
    }
}
