<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Banktranslog ServiceType
 * @subpackage Services
 */
class Banktranslog extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bank_trans_log
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bank_trans_log $parameters
     * @return \StructType\Bank_trans_logResponse|bool
     */
    public function bank_trans_log(\StructType\Bank_trans_log $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bank_trans_log($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Bank_trans_logResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
