<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Wallet StructType
 * @subpackage Structs
 */
class Wallet extends AbstractStructBase
{
    /**
     * The msisdn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $msisdn;
    /**
     * The partner_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner_code;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for Wallet
     * @uses Wallet::setMsisdn()
     * @uses Wallet::setPartner_code()
     * @uses Wallet::setStatus()
     * @param string $msisdn
     * @param string $partner_code
     * @param \StructType\Status $status
     */
    public function __construct($msisdn = null, $partner_code = null, \StructType\Status $status = null)
    {
        $this
            ->setMsisdn($msisdn)
            ->setPartner_code($partner_code)
            ->setStatus($status);
    }
    /**
     * Get msisdn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsisdn()
    {
        return isset($this->msisdn) ? $this->msisdn : null;
    }
    /**
     * Set msisdn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msisdn
     * @return \StructType\Wallet
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msisdn, true), gettype($msisdn)), __LINE__);
        }
        if (is_null($msisdn) || (is_array($msisdn) && empty($msisdn))) {
            unset($this->msisdn);
        } else {
            $this->msisdn = $msisdn;
        }
        return $this;
    }
    /**
     * Get partner_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner_code()
    {
        return isset($this->partner_code) ? $this->partner_code : null;
    }
    /**
     * Set partner_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner_code
     * @return \StructType\Wallet
     */
    public function setPartner_code($partner_code = null)
    {
        // validation for constraint: string
        if (!is_null($partner_code) && !is_string($partner_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_code, true), gettype($partner_code)), __LINE__);
        }
        if (is_null($partner_code) || (is_array($partner_code) && empty($partner_code))) {
            unset($this->partner_code);
        } else {
            $this->partner_code = $partner_code;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Status $status
     * @return \StructType\Wallet
     */
    public function setStatus(\StructType\Status $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
}
