<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionWallet StructType
 * @subpackage Structs
 */
class TransactionWallet extends AbstractStructBase
{
    /**
     * The fx_rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fx_rate;
    /**
     * The mfs_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_trans_id;
    /**
     * The name_match
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name_match;
    /**
     * The partner_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $partner_code;
    /**
     * The receive_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $receive_amount;
    /**
     * The sanction_list_recipient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sanction_list_recipient;
    /**
     * The sanction_list_sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sanction_list_sender;
    /**
     * The send_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $send_amount;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MResponse
     */
    public $status;
    /**
     * The third_party_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $third_party_trans_id;
    /**
     * Constructor method for TransactionWallet
     * @uses TransactionWallet::setFx_rate()
     * @uses TransactionWallet::setMfs_trans_id()
     * @uses TransactionWallet::setName_match()
     * @uses TransactionWallet::setPartner_code()
     * @uses TransactionWallet::setReceive_amount()
     * @uses TransactionWallet::setSanction_list_recipient()
     * @uses TransactionWallet::setSanction_list_sender()
     * @uses TransactionWallet::setSend_amount()
     * @uses TransactionWallet::setStatus()
     * @uses TransactionWallet::setThird_party_trans_id()
     * @param float $fx_rate
     * @param string $mfs_trans_id
     * @param string $name_match
     * @param string $partner_code
     * @param \StructType\Money $receive_amount
     * @param string $sanction_list_recipient
     * @param string $sanction_list_sender
     * @param \StructType\Money $send_amount
     * @param \StructType\MResponse $status
     * @param string $third_party_trans_id
     */
    public function __construct($fx_rate = null, $mfs_trans_id = null, $name_match = null, $partner_code = null, \StructType\Money $receive_amount = null, $sanction_list_recipient = null, $sanction_list_sender = null, \StructType\Money $send_amount = null, \StructType\MResponse $status = null, $third_party_trans_id = null)
    {
        $this
            ->setFx_rate($fx_rate)
            ->setMfs_trans_id($mfs_trans_id)
            ->setName_match($name_match)
            ->setPartner_code($partner_code)
            ->setReceive_amount($receive_amount)
            ->setSanction_list_recipient($sanction_list_recipient)
            ->setSanction_list_sender($sanction_list_sender)
            ->setSend_amount($send_amount)
            ->setStatus($status)
            ->setThird_party_trans_id($third_party_trans_id);
    }
    /**
     * Get fx_rate value
     * @return float|null
     */
    public function getFx_rate()
    {
        return $this->fx_rate;
    }
    /**
     * Set fx_rate value
     * @param float $fx_rate
     * @return \StructType\TransactionWallet
     */
    public function setFx_rate($fx_rate = null)
    {
        // validation for constraint: float
        if (!is_null($fx_rate) && !(is_float($fx_rate) || is_numeric($fx_rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fx_rate, true), gettype($fx_rate)), __LINE__);
        }
        $this->fx_rate = $fx_rate;
        return $this;
    }
    /**
     * Get mfs_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_trans_id()
    {
        return isset($this->mfs_trans_id) ? $this->mfs_trans_id : null;
    }
    /**
     * Set mfs_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_trans_id
     * @return \StructType\TransactionWallet
     */
    public function setMfs_trans_id($mfs_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_trans_id) && !is_string($mfs_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_trans_id, true), gettype($mfs_trans_id)), __LINE__);
        }
        if (is_null($mfs_trans_id) || (is_array($mfs_trans_id) && empty($mfs_trans_id))) {
            unset($this->mfs_trans_id);
        } else {
            $this->mfs_trans_id = $mfs_trans_id;
        }
        return $this;
    }
    /**
     * Get name_match value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName_match()
    {
        return isset($this->name_match) ? $this->name_match : null;
    }
    /**
     * Set name_match value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name_match
     * @return \StructType\TransactionWallet
     */
    public function setName_match($name_match = null)
    {
        // validation for constraint: string
        if (!is_null($name_match) && !is_string($name_match)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_match, true), gettype($name_match)), __LINE__);
        }
        if (is_null($name_match) || (is_array($name_match) && empty($name_match))) {
            unset($this->name_match);
        } else {
            $this->name_match = $name_match;
        }
        return $this;
    }
    /**
     * Get partner_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartner_code()
    {
        return isset($this->partner_code) ? $this->partner_code : null;
    }
    /**
     * Set partner_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partner_code
     * @return \StructType\TransactionWallet
     */
    public function setPartner_code($partner_code = null)
    {
        // validation for constraint: string
        if (!is_null($partner_code) && !is_string($partner_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner_code, true), gettype($partner_code)), __LINE__);
        }
        if (is_null($partner_code) || (is_array($partner_code) && empty($partner_code))) {
            unset($this->partner_code);
        } else {
            $this->partner_code = $partner_code;
        }
        return $this;
    }
    /**
     * Get receive_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getReceive_amount()
    {
        return isset($this->receive_amount) ? $this->receive_amount : null;
    }
    /**
     * Set receive_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $receive_amount
     * @return \StructType\TransactionWallet
     */
    public function setReceive_amount(\StructType\Money $receive_amount = null)
    {
        if (is_null($receive_amount) || (is_array($receive_amount) && empty($receive_amount))) {
            unset($this->receive_amount);
        } else {
            $this->receive_amount = $receive_amount;
        }
        return $this;
    }
    /**
     * Get sanction_list_recipient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSanction_list_recipient()
    {
        return isset($this->sanction_list_recipient) ? $this->sanction_list_recipient : null;
    }
    /**
     * Set sanction_list_recipient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sanction_list_recipient
     * @return \StructType\TransactionWallet
     */
    public function setSanction_list_recipient($sanction_list_recipient = null)
    {
        // validation for constraint: string
        if (!is_null($sanction_list_recipient) && !is_string($sanction_list_recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sanction_list_recipient, true), gettype($sanction_list_recipient)), __LINE__);
        }
        if (is_null($sanction_list_recipient) || (is_array($sanction_list_recipient) && empty($sanction_list_recipient))) {
            unset($this->sanction_list_recipient);
        } else {
            $this->sanction_list_recipient = $sanction_list_recipient;
        }
        return $this;
    }
    /**
     * Get sanction_list_sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSanction_list_sender()
    {
        return isset($this->sanction_list_sender) ? $this->sanction_list_sender : null;
    }
    /**
     * Set sanction_list_sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sanction_list_sender
     * @return \StructType\TransactionWallet
     */
    public function setSanction_list_sender($sanction_list_sender = null)
    {
        // validation for constraint: string
        if (!is_null($sanction_list_sender) && !is_string($sanction_list_sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sanction_list_sender, true), gettype($sanction_list_sender)), __LINE__);
        }
        if (is_null($sanction_list_sender) || (is_array($sanction_list_sender) && empty($sanction_list_sender))) {
            unset($this->sanction_list_sender);
        } else {
            $this->sanction_list_sender = $sanction_list_sender;
        }
        return $this;
    }
    /**
     * Get send_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getSend_amount()
    {
        return isset($this->send_amount) ? $this->send_amount : null;
    }
    /**
     * Set send_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $send_amount
     * @return \StructType\TransactionWallet
     */
    public function setSend_amount(\StructType\Money $send_amount = null)
    {
        if (is_null($send_amount) || (is_array($send_amount) && empty($send_amount))) {
            unset($this->send_amount);
        } else {
            $this->send_amount = $send_amount;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MResponse|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MResponse $status
     * @return \StructType\TransactionWallet
     */
    public function setStatus(\StructType\MResponse $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get third_party_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThird_party_trans_id()
    {
        return isset($this->third_party_trans_id) ? $this->third_party_trans_id : null;
    }
    /**
     * Set third_party_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $third_party_trans_id
     * @return \StructType\TransactionWallet
     */
    public function setThird_party_trans_id($third_party_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($third_party_trans_id) && !is_string($third_party_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($third_party_trans_id, true), gettype($third_party_trans_id)), __LINE__);
        }
        if (is_null($third_party_trans_id) || (is_array($third_party_trans_id) && empty($third_party_trans_id))) {
            unset($this->third_party_trans_id);
        } else {
            $this->third_party_trans_id = $third_party_trans_id;
        }
        return $this;
    }
}
